#! c:\perl\bin\perl -w
#
# Pete Griffiths 2007
# http://picprojects.org.uk
# Serial Addressable RGB LED PWM Driver
# control interface application
# Version 1.4 for Windows
# Modified for servo support
# Added support for servo commands 8,9,10 - Independant position Servo
#
use strict;

# Download this module from http://www.petesworld.demon.co.uk/homebrew/PIC/simplergb/SerialPort-0_19.zip
use Win32::SerialPort;

my $version = "1.3";
my ($addr, $rled, $gled, $bled, $fade);
my $checksum;
my $start=  255;
#my ($byte1, $byte2, $byte3, $byte4, $byte5, $byte6);
my ($rdir, $gdir, $bdir);;


	

my $Config_File = "zfpwm.cfg";
my $baud = "9600";
my $uport = 1;
my $port;
my $parity = "none";
my $databits = "8";
my $stopbits = "1";
my $handshake = "none";

print "Serial Addressable RGB LED PWM Driver control interface\n";
print "Version 1.2 for Windows\n\n";

if (@ARGV){
    
        my $cl_string = join (";",@ARGV) .";";
        chomp $cl_string;
              
        # Inspect command line string and set options if found
        #$debug = $1 if $cl_string=~ /\/d:(\d+);/; # look for /d;
             
        $baud = $1 if $cl_string=~ /\/b:(\d+);/; # look for /i:(any digits);
        $uport = ($1) if $cl_string=~ /\/p:(.*?);/; # look for /k:(any characters);
         
        #$memoryFile = ($1) if $cl_string=~ /\/m:(.*?);/; # look for /k:(any characters);
        #$seqFile = ($1) if $cl_string=~ /\/s:(.*?);/; # look for /k:(any characters);
        
        showUse() if $cl_string=~ /(\?|\/help)/; # look for ? or /help
}

$port = "COM1" if $uport == 1;
$port = "COM2" if $uport == 2;
$port = "COM3" if $uport == 3;
$port = "COM4" if $uport == 4;

my $test=0;
$test = 1 if $baud == 1200;
$test = 1 if $baud == 2400;
$test = 1 if $baud == 9600;
$test = 2 if $baud == 19200;
$test = 2 if $baud == 38400;

unless ($test) {
	      
	      print "$baud is not a valid setting for the bit rate\n\n";
	      exit;
	     }
if ($test==2){
    print "$baud not supported in free version \n\n";
}
	     

print "Using $port @ $baud bps \n";
print "Settings are changed using command line options - zfrgb.exe /? for help \n\n";

$|=1; 


my $PortObj = new Win32::SerialPort ($port)
       || die "Can't open $port: $^E\n";    # $quiet is optional


  $PortObj->baudrate($baud);
  $PortObj->parity($parity);
  $PortObj->databits($databits);
  $PortObj->stopbits($stopbits);
  #$PortObj->handshake($handshake);
  $PortObj->buffers(6, 6);
  $PortObj->write_char_time(0);
  $PortObj->write_const_time(0);
  $PortObj->is_binary(0);
  #$PortObj->datatype('raw');

  #use open IN => ":raw", OUT => ":raw";

  $PortObj->write_settings || undef $PortObj;
  
  $PortObj->save($Config_File)
       || warn "Can't save $Config_File: $^E\n";
       
 $PortObj->close || die "failed to close";
  undef $PortObj; 

  my $tie_ob = tie(*PORT,'Win32::SerialPort', $Config_File)
                 or die "Can't start $Config_File\n";
    
       
    while (1){
	
		
	print "Enter Address to send to (0 - 127, groupn, broadcast or <cr> to quit)? ";
        $addr = <STDIN>;
        chomp $addr;
	
	die "nothing entered, exiting\n\n" unless (length $addr);
	
	$addr = 128 if ($addr eq 'gr0');
	$addr = 129 if ($addr eq 'gr1');
	$addr = 130 if ($addr eq 'gr2');
	$addr = 131 if ($addr eq 'gr3');
	$addr = 132 if ($addr eq 'gr4');
	$addr = 133 if ($addr eq 'gr5');
	$addr = 134 if ($addr eq 'gr6');
	$addr = 135 if ($addr eq 'gr7');
	
	
	$addr = 144 if ($addr eq 'gc0');
	$addr = 145 if ($addr eq 'gc1');
	$addr = 146 if ($addr eq 'gc2');
	$addr = 147 if ($addr eq 'gc3');
	$addr = 148 if ($addr eq 'gc4');
	$addr = 149 if ($addr eq 'gc5');
	$addr = 150 if ($addr eq 'gc6');
	$addr = 151 if ($addr eq 'gc7');
	$addr = 152 if ($addr eq 'gc8');
	$addr = 153 if ($addr eq 'gc9');
	$addr = 154 if ($addr eq 'gc10');
	$addr = 155 if ($addr eq 'gc11');
	$addr = 156 if ($addr eq 'gc12');
	$addr = 157 if ($addr eq 'gc13');
	$addr = 158 if ($addr eq 'gc14');
	$addr = 159 if ($addr eq 'gc15');
	
	
	
	$addr = 255 if ($addr eq 'broadcast');
	
	next unless ($addr =~ /^-?\d/);
	
	if ($addr == 253){
	    
	    $addr=0 ; $start = 0; $rled = 0; $gled=0 ; $bled=0 ; $fade=0; 
	    
	}else{
	
	print "Enter Packet Type ID byte (c = cmd, d = data)? ";
        $start = <STDIN>;
        chomp $start;
	$start = 254 if (lc($start) eq 'c');
	$start = 255 if (lc($start) eq 'd');
	die "nothing entered, exiting\n\n" unless (length $start);
	
	next unless ($start =~ /^-?\d/);
	next unless ($start > 253 && $start < 256);
        
	    if ($start == 255){
	    print "Enter Red or Servo1 data (0 - 255) : ";
	    $rled = <STDIN>;
	    chomp $rled;
	    $rled=0 unless $rled;
    
	    print "Enter Green or Servo2 data (0 - 255) : ";
	    $gled = <STDIN>;
	    chomp $gled;
	    $gled=0 unless $gled;
	    
	    print "Enter Blue Servo3 data (0 - 255) : ";
	    $bled = <STDIN>;
	    chomp $bled;
	    $bled=0 unless $bled;
    
	    print "Enter Colour Fade or Servo Slew Rate (0 = no fade/slew) : ";
	    $fade = <STDIN>;
	    chomp $fade;
	    $fade=0 unless $fade;
	    	    
	    }
	    
	    
	if ($start == 254){
	    	print " 0 = Keep awake \n";
		print " 1 = Transfer Colour data \n";
		print " 2 = Save to EEPROM \n";
		print " 3 = New address \n";
		print " 4 = New bit rate \n";
		print " 5 = Enable/Disable PWM \n";
		print " 6 = Enable/Disable inactivity timer \n";
		print " 7 = Transfer Servo data\n";
		print " 8 = Set Servo1 position\n";
		print " 9 = Set Servo2 position\n";
		print " 10 = Set Servo3 position\n";
		
	    print "Enter Command : ";
	    $rled = <STDIN>;
	    chomp $rled;
	    $rled = 0 unless $rled;
	    next unless ($rled =~ /^-?\d/);
	    
	    if ($rled > 2 && $rled <7 || $rled > 7){
	
		print "Enter New Address (0 - 127)" if ($rled == 3);
		print "0 for Bit Rate 1200bps \n" if ($rled == 4);
		print "1 for Bit Rate 2400bps \n" if ($rled == 4);
		print "2 for Bit Rate 9600bps \n" if ($rled == 4);
		print "3 for Bit Rate 19200bps \n" if ($rled == 4);
		print "4 for Bit Rate 38400bps \n" if ($rled == 4);
		print "Enter New Bit Rate (0 - 3) : " if ($rled == 4);
		print "Disable PWM = 0    : " if ($rled == 5);
		print "Enable PWM (1-255) : " if ($rled == 5);
		print "Disable Inactivity timer = 0    : " if ($rled == 6);
		print "Enable Inactivity timer (1-255) : " if ($rled == 6);
		print "Enter new servo position (0-255): " if ($rled >7);
		$gled = <STDIN>;
		chomp $gled;
		next unless ($gled =~ /^-?\d/);
	    }else{
		$gled=0;
		}
	       
	    $bled = 1;
	    $fade = 0;
	    }
	}
	    
	print "-------------------------------------------------------------\n";
	rxPacket();
	print "-------------------------------------------------------------\n";
        print "\n";
        

    }
    
    
sub rxPacket {    
        $checksum = ((($start + $addr + $rled + $gled + $bled + $fade)^255 )+1) & 255;
       
	my $data = chr($start) .chr($addr) .chr($rled) .chr($gled) .chr($bled) . chr($fade) .chr($checksum);
	
	print "Packet sent | $start : $addr : $rled : $gled : $bled : $fade : chksum = $checksum\n";
	syswrite PORT, $data;
	

}
        
        
sub showUse {
    
    print "\n";
    print "Version $version\n";
    print "\n";
    print "zfrgb.exe [/p:commport] [/b:bit_rate] \n\n";
    print "Supports Comm ports 1-4\n";
    print "Supports bit rates 1200, 2400, 9600, 19200, 38400\n";
    print "\n";
    print "Default is COM1, 9600bps\n\n";
    print "Example use:\n";
    print "zfrgb.exe /p:2 /b:1200\n\n";
    die "\n";     
      
    
}
 
 
  

 
 
