#! c:\perl\bin\perl -w
use strict;

   
use Win32::SerialPort;

my ($addr, $rled, $gled, $bled);
my $checksum;
my $start=  0x81;
my ($byte1, $byte2, $byte3, $byte4, $byte5, $byte6);
my ($rdir, $gdir, $bdir);
my $count = 0;

	

my $Config_File = "serport2.cfg";
my $baud = "2400";
my $port = "COM1";
my $parity = "none";
my $databits = "8";
my $stopbits = "1";
my $handshake = "none";

$|=1; 


my $PortObj = new Win32::SerialPort ($port)
       || die "Can't open $port: $^E\n";    # $quiet is optional


  $PortObj->baudrate($baud);
  $PortObj->parity($parity);
  $PortObj->databits($databits);
  $PortObj->stopbits($stopbits);
  #$PortObj->handshake($handshake);
  $PortObj->buffers(6, 6);
  $PortObj->write_char_time(0);
  $PortObj->write_const_time(0);
  $PortObj->is_binary(0);
  #$PortObj->datatype('raw');

  #use open IN => ":raw", OUT => ":raw";

  $PortObj->write_settings || undef $PortObj;
  
  $PortObj->save($Config_File)
       || warn "Can't save $Config_File: $^E\n";
       
 $PortObj->close || die "failed to close";
  undef $PortObj; 

  my $tie_ob = tie(*PORT,'Win32::SerialPort', $Config_File)
                 or die "Can't start $Config_File\n";
    
    $addr = 255;
    $rled = 0;
    $gled = 0;
    $bled = 0;
    sendPacket();
    my $n=1;
    
    my $rad = 2 * 3.141;
    my $m=0;

while (1){
    
    for ($count = 0; $count < $rad; $count = $count + 0.08) {
    $m = 1;
    $rled = (123 + sin ($count + ($rad * $m)) * 115) & 255;
    $gled = (123 + sin ($count + ($rad * $m * 1/3)) * 115) & 255;
    $bled = (123 + sin ($count + ($rad * $m * 2/3)) * 115) & 255;
    #print "$n : $rled : $gled : $bled : $m\n";
    $n++;
    sendPacket();
    }

}
   
   my $strobe=0; 
while (1){
	
	for ($count = 0; $count < $rad; $count = $count + .2) {
		$strobe = (100 + sin ($count/2) *75);
		$strobe = 2;
	if ($rled == 0){
		$rled = $gled = $bled = 240;
		sendPacket();
	}else{
		$rled = $gled = $bled = 0;
		sendPacket();
		#Win32::Sleep($strobe);
		sendPacket();
		#print "$strobe \n";
	}
	}
}


        
sub	sendPacket{
        
	$rled = $rled & 255;
	$gled = $gled & 255;
	$bled = $bled & 255;
	
	$checksum = ((($start + $rled + $gled + $bled)^255 )+1) & 255;

        $byte1 = chr($start);
        $byte2 = chr($addr);
        $byte3 = chr($rled);
        $byte4 = chr($gled);
        $byte5 = chr($bled);
        $byte6 = chr($checksum);
        
	my $data = chr($start) .chr($rled) .chr($gled) .chr($bled) .chr($checksum);
          
	syswrite PORT, $data;
	Win32::Sleep(10);
               
    }
        
        

	
 
 
  

 
 
