;-----------------------------------------------------------------------------------
; Version 108.
; bdcm_remapmain.inc

main	; Startup initialisation code
	;
	
	banksel	OSCCON
	; Set internal clock frequency.  
	; This clock is also used by Timer0 and Timer2.
	; Adjusting this will alter the Timer2 period so allows different periods from the default
	; periods for a 4Mhz int clock which are: 15.6Khz, 3.8Khz, 980Hz
	; For example, setting to 2Mhz would give 7.8Khz, 1.9Khz, 490Hz
	; Note: If you change the clock frequency you need to also adjust the Timer0 pre-scaler as well
	;  
	;IRCF<2:0>: Internal Oscillator Frequency Select bits
	;100 = 1 MHz	   - change  Timer0 Pre-scaler set to 1:16
	;101 = 2 MHz	   - change  Timer0 Pre-scaler set to 1:32
	;110 = 4 MHz     - default Timer0 Pre-scaler set to 1:64
	;111 = 8 MHz	   - change  Timer0 Pre-scaler set to 1:128
	
	;-----------------------------------------------------------------------------------------------
	; Set Clock
#ifdef PWMFREQ_A
	movlw	(1<<IRCF2 | 0 << IRCF1 | 0<<IRCF0) ;  Set clock to 1Mhz (3.9Khz, 950Hz, 245Hz)
#endif
#ifdef PWMFREQ_B
	movlw	(1<<IRCF2 | 0 << IRCF1 | 1<<IRCF0) ;  Set clock to 2Mhz (7.8Khz, 1.9Khz, 490Hz)
#endif
#ifdef PWMFREQ_C
	movlw	(1<<IRCF2 | 1 << IRCF1 | 0<<IRCF0) ;  Set clock to 4Mhz (15.6Khz, 3.8Khz, 980Hz)
#endif
#ifdef PWMFREQ_D
	movlw	(1<<IRCF2 | 1 << IRCF1 | 1<<IRCF0) ;  Set clock to 8Mhz (31.2Khz, 7.6Khz, 1.96Khz)
endif
	movwf	OSCCON
	;-----------------------------------------------------------------------------------------------
	; Set TMR0 Prescaler
#ifdef PWMFREQ_A
	movlw	(0<<PS2 | 1<<PS1 | 1<<PS0 )           ;TMR0 1:16 prescale
#endif
#ifdef PWMFREQ_B
	movlw	(1<<PS2 | 0<<PS1 | 0<<PS0 )           ;TMR0 1:32 prescale	
#endif
#ifdef PWMFREQ_C
	movlw	(1<<PS2 | 0<<PS1 | 1<<PS0 )           ;TMR0 1:64 prescale
#endif
#ifdef PWMFREQ_D
	movlw	(1<<PS2 | 1<<PS1 | 0<<PS0 )           ;TMR0 1:128 prescale
#endif
	movwf	OPTION_REG
	;-----------------------------------------------------------------------------------------------
		
	banksel GPIO 
		
              clrf          GPIO      
	movlw	(1<<CM2 | 1<<CM1 | 1<CM2)	; turn of comparator
	movwf	CMCON0
				
	banksel ANSEL
		
              movlw         (1<<ADCS1 | 1<<speedADC)	; set analogue input for VR1 | Fosc/32
              movwf         ANSEL         
	
	movlw	~(1<<motorPWM | 1<<LED )	; set output port bits
	movwf	TRISIO
	              
              movlw         (1<<Switch | 1<<RunStop)	; enable weak-pull-ups
              movwf         WPU
              
 	movlw         .63	; Altering this value will change the PWM frequency and 
			; duty cycle resolution.
			; Read 12F683 datasheet to understand the relationship
			; between this register and PWM frequency / duty cycle
              movwf         PR2              

              banksel GPIO

	clrf          CCPR1L        ; ensure register is cleared at power-on to avoid spurious
                                          ; PWM output in first cycle. (Change added in V1.0.7)
                                          ; DC1B1/DC1B0 bits of CCP1CON are cleared at power-on-reset
	
	movlw	b'00001100'	; initialise / enable PWM module
	movwf	CCP1CON

              clrf          TMR2
	bsf	T2CON, TMR2ON	; turn on timer 2
	


              ; clear GPR from 0x20 to 0x7F.  Just keep things clean and tidy
              movlw         0x20
              movwf         FSR
_clearnext    clrf          INDF
              incf          FSR,F
              btfss         FSR,7
              goto          _clearnext	

	movlw	filterArray
	movwf	FSR
	
#ifdef	doSoftStart
	bsf	flagbits, fSoftStart
#else
	bcf	flagbits, fSoftStart
#endif
	
	clrf	softStart
	movlw	cSStimer		; preload soft start timer constant
	movwf	ssIntervalTimer

	; read EEPROM to get the saved prescaler value for Timer 2
	;
	call	recall.map.select
	movwf	remapSelect
	andlw	0x03	; keep only valid map select bits
	xorlw	0x03	; test if they are both 1
	skpnz		; skip next if not
	clrf	remapSelect	; else reset to 0x00


	;--------------------------------------------------------------------------------
	movlw	b'00001111'	; setup ADC peripheral and start a conversion
	movwf	ADCON0	
	
_wait1	decfsz	softStart,F	; conversion delay
	goto	_wait1

_wait2	btfsc	ADCON0, GO_DONE	; wait for ADC conversion to complete
	goto	_wait2
	movfw	ADRESH		; read high 8 bits of result
	bsf	ADCON0, GO_DONE	; start new conversion
	
	;--------------------------------------------------------------------------------

	bsf	PIR1, EEIF	; preset EEIF interrupt flag, write EEPROM code checks this	




;----------------------------------------------------------------------------------------------------
;  Main code block runs from here
;
              
_mainLoop	bcf	PIR1,TMR2IF
	
_idleLoop	btfsc	PIR1, TMR2IF	; test TMR2 interrupt flag, skip if clear
	call	_updatePWM	; update PWM duty cycle

	btfss	INTCON, T0IF
	goto	_idleLoop
	

	bcf	INTCON, T0IF
	movlw	cTIMER0
	addwf	TMR0,F
	

;----------------------------------------------------------------------------------------------------
;  ADC is read at 5mS intervals 
;  Original ADC read was done in the PWM code section.  Now been moved here so it is updated at a
;  consistent 5mS interval
;  PWM code uses the working copy of the ADC result stored in mapIndex variable
;  Changed in v1.0.4 - 16/04/2013
		
_waitADC	btfsc	ADCON0, GO_DONE	; wait for ADC conversion to complete
	goto	_waitADC
	movfw	ADRESH		; read high 8 bits of result into Wreg
	
	
	movwf	mapIndex		; copy to working variable
	call	filterADC


	;--------------------------------------------------------------------------------------
	; SoftStart code 
	; original feature added 17/02/2012
	
	decfsz	ssIntervalTimer,F
	goto	_startNewADC
	
	incf	softStart,F		; increment SoftStart index
	
	movlw	cSStimer		; reload soft start timer constant
	movwf	ssIntervalTimer

	btfss	flagbits, fSoftStart	; test soft start flag
	goto	_startNewADC
	
	; W == MapIndex
	; SoftStart - MapIndex 
	; SoftStart >= MapIndex then Carry == 1
	movfw	mapIndex		; load Wreg with mapIndex 
	subwf	softStart,W		; compare soft start value with speed control position  
	skpnc			; skip next if SoftStart < Speed Contol
	bcf	flagbits, fSoftStart	; end of soft start - clear flag bit
	
	movfw	softStart		; copy SoftStart
	movwf	mapIndex		; to mapIndex (overwrites value read from speed control)	
	
_startNewADC	nop
	bsf	ADCON0, GO_DONE	; start another conversion so it's ready next time round.
		
;------------------------------------------
; LED status function
; remapSelect  LED blink	remap include file
; 0            on	1st include
; 1            1.5Hz	2nd include
; 2            6.2Hz	3rd include

_ledUpdate	movlw	1<<LED
	movf	remapSelect,F	
	skpnz	
	goto	led.on
	movlw	.16
	btfsc	remapSelect,1
	movlw	.4
	addwf	blinkRate,F
	skpc
	goto	switch.check
	movfw	GPIO
	xorlw	1<<LED
led.on	movwf	GPIO
	

;------------------------------------------
; switch function
switch.check	btfss	GPIO, Switch
	goto	switch.Active
	clrf	switchTimer
	goto	_mainLoop

switch.Active	movfw	switchTimer	; test switch timer value
	xorlw	.100	; 5mS x 100 = 0.5S
	skpz		; when it reaches .100 increment remapSelect
	goto	switch.timer.inc
	; cycle through remapSelect options
	; Valid settings are
	; 00 - 0
	; 01 - 1
	; 10 - 2
	incf	remapSelect,F
	movfw	remapSelect
	xorlw	0x03	; compare to 3 
	skpnz
	clrf	remapSelect
	movfw	remapSelect
	call	save.map.select	; save remap in use to EEPROM
              
              bsf           flagbits, fMapChange        ; set flag when new remap is selected.

switch.timer.inc
	incf	switchTimer,W	; increment switch timer when S1 pressed
	skpnz
	goto	_mainLoop	; if counter reaches 255, hold it at 255
	movwf	switchTimer
	goto	_mainLoop




;--------------------------------------------------------------------
; PWM update functions
; Called once per PWM period, after Timer2 overflow sets timer interrupt flag.
; Poll flag in the main code loop rather than an interrupt driven routine.
;
_updatePWM	bcf	PIR1, TMR2IF		; clear timer2 interrupt flag

_testRunIn	btfsc	GPIO, RunStop		; test RunStop input
	goto	_runNormal		; if RunStop input high, run as normal

;Version 1.0.8, fix for PWM duty remaining at 0% after after RunStop returns high 
_runStop      clrf	duty		; set duty to 0% if RunStop input low
	clrf	dutyLast		; set dutyLast to 0% (fix in V1.0.8)
#ifdef doSoftStart
	bsf	flagbits, fSoftStart
        	clrf	softStart
	movlw	cSStimer		; preload soft start timer constant
	movwf	ssIntervalTimer
#endif
	goto	_zeroDuty

;--------------------------------------------------------------------
; Use lookup table to remap the value from the ADC input
; to a new value that will be loaded in to the PWM duty cycle register

	
	; compare current duty value with previous.
	; only update PWM hardware registers if value has changed
_runNormal    Call	get.remap.duty
	
              movwf	duty	; read it
	xorwf	dutyLast,F	; compare it to last
	movwf	dutyLast	; copy new value to last ready for next pass
	skpz		; skip next if duty has changed
	goto          _updatePeriod                     ; 
              btfss         flagbits, fMapChange           ; skip next if selected map has been changed - flag bit set
              return		; else return if duty value unchanged 



	; set PWM period register
_updatePeriod	
              bcf           flagbits, fMapChange           ; always clear this flag since we will be updating the duty/period with new values
              call	get.remap.period
	xorwf	T2CON,W
	andlw	0x03
	xorwf	T2CON,F
	

_zeroDuty	; Duty cycle register is are double buffered. These are only transferred on Timer2/PR2 match
	; and we only get here immediately after that happens, so we can update the registers
	; before the next reload takes place.
	;
	; We need to take the  8-bit duty cycle value and place the upper 6 bits into CCPR1L 
	; and the two LSBs into DC1B1, DC1B0 of CCP1CON.
	
	
	incf	duty,W
	skpnz
	goto	_100percent
	
	swapf	duty, W
	xorwf	CCP1CON,W
	andlw	0x30
	xorwf	CCP1CON,F
	
	rrf	duty,F	
	rrf	duty,W
	andlw	0x3F
	movwf	CCPR1L
	
	return
	
_100percent	movlw	0xFF
	movwf	CCPR1L
	return

;--------------------------------------------------------------------
; functions to Save and Recall  PWM Frequency setting from EEPROM
;
save.map.select
	btfss	PIR1, EEIF
	goto	$-1
	BANK1
	movwf	EEDAT
	clrf	EEADR
	bsf	EECON1, WREN
	movlw	0x55
	movwf	EECON2
	movlw	0xAA
	movwf	EECON2
	bsf	EECON1, WR
	BANK0
	return


recall.map.select
	BANK1
	clrf	EEADR
	bsf	EECON1, RD
	movfw	EEDAT
	BANK0
	return


_otherReset	BANK0
	clrf	T2CON
	goto	_otherReset




;---------------------------------------------------------
; Use lookup table to get duty cycle and period remap data
; Duty and period data are interleaved which makes the lookup
; function a little complicated, but better for creating
; the table data 

get.remap.period
	incf	offset,F	; offset ==1 for period data
	skpnz
get.remap.duty
	clrf	offset	; offset ==0 for duty data
	movlw	HIGH remap.table.base
	movwf	PCLATH
	clrc
	rlf	remapSelect,W
	addwf	PCLATH,F
	clrc
	rlf	mapIndex,W
	skpnc
	incf	PCLATH,F
	addlw	LOW remap.table.base
	skpnc
	incf	PCLATH,F
	
	addwf	offset,W
	skpnc
	incf	PCLATH,F
	movwf	PCL


;---------------------------------------------------------
; filter

filterADC
 	
 	; read oldest value, subtract from 16 bit rolling sum.
 	movfw	INDF
 	subwf	filterSumL,F
 	skpc
 	decf	filterSumH,F
 
 	; insert new value over oldest value in array
 	; then add latest value to rolling sum (16 bit result)
 	movfw	mapIndex
 	movwf	INDF
 	addwf	filterSumL,F
 	skpnc
 	incf	filterSumH,F
 
 	
 	; increment array index, if end of array, reset pointer to start
 	incf	FSR,F	
 	movlw	filterArray+.8 ;(average 8 readings)
 	xorwf	FSR,W
 	movlw	filterArray
 	skpnz
 	movwf	FSR
  		
 	; divide sum by number samples to get rolling avereage (in this case divide by 8)	
 	rrf	filterSumH,W
 	movwf	mapIndexH
 	rrf	filterSumL,W
 	movwf	mapIndex
 	
 	rrf	mapIndexH,F
 	rrf	mapIndex,F
 	
 	rrf	mapIndexH,F
 	rrf	mapIndex,F


 	return