;**********************************************************************
;                                                                     *
;    Filename:     bdcm_remap108_common.asm                           *
;    Date:         22 July 2018                                        *
;    File Version: 1.0.8 Common                                       *
;                                                                     *
;    Author:  Pete Griffiths                                          *
;    Company: picprojects.org.uk                                      *
;                                                                     * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files Required: P12F683.INC                                      *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:                                                           *
;                  |--\/--|                                           *
;             Vdd -|1    8|- Vss                                      *
;       Switch in -|2    7|- LED                                      *
;     Analogue in -|3    6|- ^Stop/Run control in                     *
;            MCLR -|4    5|- PWM Output                               *
;                  --------                                           *
;                                                                     *
; Switch in, push-to-make  between Vss and Pin 2                      *
; Analogue in 5K potentiometer between Vdd and Vss,                   *
; 1K resistor from potentiomter wiper to Pin 3                        *
;                                                                     *
; MCLR, 1K to Vdd                                                     *
; PWM Output to N channel logic level MOSFET gate terminal via 220R   *
; LED, standard 5mm LED to ground via 150R                            *
;**********************************************************************
;                                                                     ;
; Notes on operation           			;                                        
;                                                                     ;
; Voltage at Analogue sets PWM duty cycle (0V = 0% to 5V = 100% )     ;
;                                                                     ;
; Press Switch to cycle through map table options                     ;
; Map Table 1  - LED on                                               ;
; Map Table 2  - LED fast blink (~6Hz  )                              ;
; Map Table 3  - LED slow blink (~1.5Hz)                              ;
;                                                                     ;
; Setting is saved to EEPROM and recalled at power on                 ;
;                                                                     ;
; PWM Output, active high. Will drive N Channel logic-level MOSFET    ;
;                                                                     ;
; Low level on ^Stop/Run input  shuts off PWM	              ;
;                                                                     ;
;**********************************************************************
;
; 1.0.2  Fixes bug in restoring table select data from EEPROM
; 1.0.3  Fixes incorrect bit being set in CCP1CON register.
; 1.0.4  SS
;        Adds power-on soft start feature to 1.0.3 code
; 1.0.5  Common version - changes are:
;        1)soft start code is enabled/disabled at assembly time by label define

;        2)ADC conversion and softstart code moved from PWM update to 5mS interval 
;          timer function code.  This ensures at the higest PWM period setting the
;          duty cycle/ period registers are not written to during a reload.

;        3)Added code to allow alternate clock frequency to be set at assembly time
;          This enables different PWM periods to be used.
;
;        4)Altered way PWM duty cycle register is updated to elimiante noise at
;          low duty cycles 
;
; 1.0.6  1) Update PWM period and duty registers only when input value changes.  
;        2) Force 100% PWM output when duty value = 255.  Because of the way the PWM 
;           peripheral hardware works within the PIC itself, setting the duty cycle
;           register to 255 actually only gets to 99.6% duty
;
; 1.0.7  1) Clear PWM CCPR1L and DC1B1/DC1B0 bits of CCP1CON before enabling PWM module
;           since the value in the register pair is undefined after reset which can 
;           cause a random output of the PWM at power-on.
;
;        2) Fixed issue where changing the selected map would not register until the
;           ADC duty cycle input value changed.  Now when a new map is selected it 
;           forces an updated of the PWM registers with the new map values.
;
; 1.0.8     Fix issue where PWM output doesn't restart after the RunStop input has been
;	    activated until the input from the duty cycle potentiometer has changed
;**********************************************************************

; Enabling SOFT START Feature
; ---------------------------
; The code can be assembled with the 'soft startup' feature enabled or disabled.
; The feature is disabled if the #define doSoftStart is commented out by inserting a ; at the start of the line
; The feature is enabled if the #define doSoftStart is uncommented (no ; at the start of the line)
;#define	doSoftStart


; Set PWM period/frequcny 
; ---------------------------
; Uncomment one line only below to set the PWM frequncy/period options
;#define	PWMFREQ_A	;Set clock to 1Mhz for PWM frequency of (3.9Khz, 950Hz, 245Hz)
;#define	PWMFREQ_B	;Set clock to 2Mhz for PWM frequency of (7.8Khz, 1.9Khz, 490Hz)
#define	PWMFREQ_C	;Set clock to 4Mhz for PWM frequency of (15.6Khz, 3.8Khz, 980Hz)
;#define	PWMFREQ_D	;Set clock to 8Mhz for PWM frequency of (31.2Khz, 7.6Khz, 1.96Khz)


; *** Set Tabs to 14 when viewing the source code listing for nice formatting of output ***

	list	p=12f683		; list directive to define processor
	#include	<P12F683.inc>		; processor specific variable definitions
	
	__CONFIG    _CP_OFF & _CPD_OFF & _BOD_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _FCMEN_OFF & _IESO_OFF
	
	errorlevel -302	; suppress banksel warning messages

; Load code release data in to EEPROM 
	org 0x2108
	de	" http://picprojects.org.uk "
	de	" Pete Griffiths (c) 2008-2018 "
	de	" PWM Motor Controller with remap 1.0.8 Common code base"



;***** VARIABLE DEFINITIONS

	cblock 0x20
	 duty
	 dutyLast
	 mapIndex
	 mapIndexH
	 switchTimer	
	 blinkRate
	 LEDstate
	 counter
	 remapSelect
	 offset
	 softStart
	 ssIntervalTimer
	 flagbits
	 filterSumL
	 filterSumH
	 filterArray:16
	 filterArrayEnd
 	 
	endc

;****************************************************************************
; Defines and equates
;****************************************************************************
#define	BANK0		bcf	STATUS,RP0	;Select BANK0
#define	BANK1		bsf	STATUS,RP0	;Select BANK1


LED	equ	0	; GPIO0 PWM frequency indicator LED
RunStop	equ	1	; GPIO1, Run/Stop control input
motorPWM	equ	2	; GPIO2 PWM drive output
speedAdj    	equ           4	; GPIO4 (AN3) analogue input sets PWM duty cycle
MCLR	equ	3	; MCLR hardware reset in
Switch	equ           5            	; GPIO5 PWM frequency select switch

speedADC	equ	3	; AN3 analogue channel for duty cycle 

fSoftStart	equ	0	; soft start flag
fMapChange    equ           1             ; set flag if selected remap is changed (by pressing Sw1)

cTIMER0	equ	.179	; reload for Timer0, with 1:64 prescaler gives Timer period of 5mS

cSStimer	equ	.1	; Soft Startup Timer. Increments at cSStimer x 5ms

;**********************************************************************
	ORG		0x000		; processor reset vector
	#include      bdcm_remapmain108_common.inc

remap.table.base

	; ---------------------------------
	; Include upto 3 remap data include files here
	; 
	; ---------------------------------
	; 1st include -> remapSelect 0 -> LED on
	#include	remapData1.inc

	; 2nd include -> remapSelect 1 -> LED 6.2Hz
	#include	remapData2.inc

	; 3rd include -> remapSelect 1 -> LED 1.5Hz
	#include	remapData3.inc
	;#include	remapData4.inc

	fill (retlw 0x00), 0x800-$

	END           ; directive 'end of program'


