;--------------------------------------------------------
; 4mS Time Out
; This code runs approximately every 5mS
; The PWM code calls it at the end of each PWM 
;  Because the PWM code takes approximatley 4mS to run
; This method is accurate enough to get predicatable delays
; needed for this application.   

_timerOut       

;-----------------------------------------------------
; Servo pulse detect

	btfss	GPIO, 4	; test GPIO4 input
	goto	esc	; exit if GPIO4 is low (servo pulse active)
		
	btfss	PIR1, TMR1IF	; test TMR1IF
	goto	esc	; exit if no Timer interrupt has occured
	
	; We only get here if GPIO4 is high AND TMR1IF is set (timer has run)
	; this means we have seen one servo pulse
	
	clrf	outputMask	; intialise output control mask to 0x00
	
	bcf	T1CON, TMR1ON	; stop timer to make sure it doesn't run while we're reading it
	
	; Timer 1 is clocked at 8uS intervals so
	; 1mS = 1000uS/8uS = TMR1L register = 125
	
	movfw	TMR1L	; read Timer1 low into Wreg
	addlw	.99	; 1250uS / 8uS = 156.  156+99 = 255
	skpnc		; If TMR1L is > 156 the +99 will set Carry flag
	bsf	outputMask,2	; and we set the bit in the output mask
	
	movfw	TMR1L	; read Timer1 low into Wreg
	addlw	.68	; 1500uS / 8uS = 187.  187+68 = 255
	skpnc		; If TMR1L is > 187 the +68 will set Carry flag
	bsf	outputMask,1	; and we set the bit in the output mask
	
	movfw	TMR1L	; read Timer1 low into Wreg
	addlw	.37	; 1750uS / 8uS = 218.  218+37 = 255
	skpnc		; If TMR1L is > 187 the +37 will set Carry flag
	bsf	outputMask,0	; and we set the bit in the output mask

	; now we reset Timer1 ready for next servo pulse
	movlw	0xFF	; Set TMR1L/H to 0xFFFF
	movwf	TMR1H	; The first clock pulse after the servo input goes low will set the TMR1IF
	movwf	TMR1L	; and we then know the servo pulse has gated the Timer
	
	bcf	PIR1, TMR1IF	; clear Timer1 interrupt flag

	bsf	T1CON, TMR1ON	; enable timer 1

;-----------------------------------------------------
; EEPROM save counter
                                
 esc               call            _swapFSR
                call            _essRun
                call            _swapFSR
                
                movf            saveCnt,F
                bz              _switchCheck
                decfsz          saveCntPS,F
                goto            _switchCheck
                decfsz          saveCnt,F
                goto            _switchCheck
                movlw           .1
                movwf           ess
;-----------------------------------------------------
; Sequence Switch Check

_switchCheck    btfsc           GPIO,seqSw
                goto            _seqSwUp        
                                
_seqSwDown      incf            seqSwCnt,F      ; increment seqSwCnt counter variable
                skpnz                           ; if result == 0, counter has wrapped round
                incf            seqSwCnt,F      ; hold count at 255			
                goto            _fadeState

_seqSwUp        movlw           -.4             ; 20mS
                addwf           seqSwCnt,W      ; was switch down for over 20mS
                bc              _swShort
                clrf            seqSwCnt
                goto            _fadeState
                

_swShort        call            _advSeq         ; advance to next sequence
                call            _seqData        ; get first set of sequence data
                clrf            rpwm            ; reset current Red pwm to 0
                clrf            gpwm            ; reset current Greeb pwm to 0
                clrf            bpwm            ; reset current Blue pwm to 0
                call            _fadeDir        ; set fade direction
                movlw           cHOLDPRESCALER  ; reset hold time prescaler
                movwf           holdTimerPS
                clrf            seqSwCnt
                movlw           cSAVETIMER      ; set save to EEPROM timer
                movwf           saveCnt         ; for delay after last sequence change.
                              

;-----------------------------------------------------
; fade / hold state function select
                
_fadeState      movf            fadeflag,F
                bz              _holding
;------------------------------------------------------
; fade          
                
_fading         decfsz          fadeTimer,F
                return
                movfw           rate
                movwf           fadeTimer

;----------------------------------------
; Fade stepper
;

_Rfade          movfw           rnew
                xorwf           rpwm,W
                bnz             $+3
                bcf             fadeflag,red
                goto            _Gfade

                movfw           Rdif
                addwf           Rcnt,F
                skpc            
                goto            _Gfade
                movfw           CntBase
                addwf           Rcnt,F
                movfw           rdir
                addwf           rpwm,F
                
_Gfade          movfw           gnew
                xorwf           gpwm,W
                bnz             $+3
                bcf             fadeflag,green
                goto            _Bfade

                movfw           Gdif
                addwf           Gcnt,F
                skpc            
                goto            _Bfade
                movfw           CntBase
                addwf           Gcnt,F
                movfw           gdir
                addwf           gpwm,F

_Bfade          movfw           bnew
                xorwf           bpwm,W
                bnz             $+3
                bcf             fadeflag,blue
                return
                
                movfw           Bdif
                addwf           Bcnt,F
                skpc            
                return          
                movfw           CntBase
                addwf           Bcnt,F
                movfw           bdir
                addwf           bpwm,F
                return




;------------------------------------------------------
; Hold pwm values timer         
                
_holding        movf            holdTimerHi,F   ; test holdTimerHi == 0
                bz              _holdSeqNext    ; no hold if it was 0
                
                decfsz          holdTimerPS,F
                return
                movlw           cHOLDPRESCALER
                movwf           holdTimerPS
                decfsz          holdTimerHi,F
                return
_holdSeqNext    call            _seqData
                call            _fadeDir
                
                return

