; ********************************************************************************
; RC Model Navigation Lights LED driver
; 
; Release Code 1.0.0 (02/06/2012)
; Pete Griffiths (c) 2012
; info@picprojects.org.uk
; Written and assembled using MPLAB v8.80
; note: source code formated for Tab size = 16 spaces
;
; ********************************************************************************
; Based on Picprojects Generic RGB Standalone LED driver code V3.0.3
;
; Revision information
;
; Release Code 1.0.0 (02/06/2012)
;
; Changes made from Generic RGB Standalone LED driver code V3.0.3 on which it is based,
;
; Removed the hold function and sleep functions
; Removed code for active low outputs
; Modifed the PWM driver code. 8 bit PWM with 250Hz period.
; Created custom sequences for Navigation light effects
; Data format for the sequence data remains unchanged from the RGB code.
;
; Release Code 1.0.1 (16/12/2012)
; 
; Added servo control input to allow outputs to be activated under control
; of servo 1-2mS pulse.
;
; -----------------------------------------------------------------------------------
;
; This code will run on 12F629 / 12F675 and 12F683. Select the desired processor
; from the Configure - Select Device menu option in MPLAB IDE, then use the
; Project - Quickbuild option to create the .HEX output file.
; 
; Look for errors during assembly. In particular errors in the SequenceData.inc
; file that indicate either a missing comma in the data, or more data than the 
; chosen PIC has available program memory.
; 
; Be carefull to enter the data in the SequenceData.inc file correctly.  The program
; is only smart enough to work out where your sequences start and finish if you enter
; it in the correct format.  Errors in the data may cause the code to crash.
;
; ********************************************************************************
; Note: For 12F629 and 12F675
; All timings are based on the internal 4Mhz PIC oscillator.  The OSCCAL value is read
; from program memory at 0x3FF and written to the OSCAL register.  This value must be
; present and correct. 
;
;             -=# IF IT IS MISSING THE CODE WILL NOT RUN CORRECTLY #=-
; See http://picprojects.org.uk/projects/recal/ if you need to recalibrate the PIC
;
; This does not apply to 12F683 as it doesn't use this method to calibrate the oscillator
;
; ********************************************************************************
; Pinout connections 
;
; Supply voltage 4 to 5 volts DC
;                            ___ ___
;                   (+) Vdd -|1 ^ 8|- Vss (-)
;      Sequence Change Sw1  -|2   7|- Beacon output
;              Servo Input  -|3   6|- Strobe output
;  MCLR.tie to Vdd via 10K  -|4   5|- Static output
;                            
;  Ensure that;
;  MCLR is pulled to Vdd using 10K resistor for 12F629/675. 
;  A 100nF ceramic capacitor is placed between Vdd and Vss to decouple the supply voltage.
;
; Servo input is an inverted servo pulse signal (use NPN transistor to invert normal servo pulse)
;
; Sw1: Press and relase to step to next sequence
;
; Sequence selected is save to EEPROM about 10 seconds after switch last pressed.
; At power-on the program uses the last saved sequence read from EEPROM.
;
;
; ********************************************************************************

  IFDEF  __12F683
                #include "p12f683.inc"
                #define ADCpresent
  ENDIF

          
  IFDEF  __12F675
                #include "p12f675.inc"
                #define ADCpresent
  ENDIF

  IFDEF  __12F629
                #include "p12f629.inc"
                
  ENDIF

  IFDEF __12F683                
     __CONFIG       _CP_OFF & _WDT_OFF & _BOD_OFF &_PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_ON & _CPD_OFF
  ELSE
     __CONFIG       _CP_OFF & _WDT_OFF & _BODEN_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_ON & _CPD_OFF
  ENDIF
  
                errorlevel -302 ; suppress banksel warning messages
       
; Program data memory variables
; --------------------------------------------
;          
                cblock          0x20 
                                 
                 rdir           ; red fade direction
	   gdir           ; green fade direction
                 bdir           ; blue fade direction
                 Rdif           ; absolute difference between red now and next
                 Gdif           ; absolute difference between green now and next
                 Bdif           ; absolute difference between blue now and next
                 Rcnt           ; fade step counter red
                 Gcnt           ; fade step counter green
                 Bcnt           ; fade step counter blue
                 CntBase        ; fade base count holding variable
                 fadeflag       ; fade complete flag variable
                 pwmramp        ; pwm ramp counter
                 sbl            ; Sequence Base Low
                 sbh            ; Sequence Base High
                 seql           ; Current Sequence data pointer Low
                 seqh           ; Current Sequence data pointer High
                 currentSeqNo   ; Current Sequence No
                 highSeqNo      ; Highest Sequence No
                 rate           ; Fade rate
                 hold           ; Sequence hold time
                 rnew           ; red data
                 gnew           ; green data
                 bnew           ; blue data
                 seqSwCnt       ; sequence switch counter
   
                 saveCntPS      ; save to EERPOM counter prescaler
                 fadeTimer      ; fade rate timer counter
                 holdTimerPS    ; hold timer prescaler
                 holdTimerHi    ; hold timer counter
                 GPIOcopy	    ; working copy of GPIO output
                 outputMask	    ; Output control mask set by servo input state
	
	 base:6         ; eeprom save data buffer
      	 saveCnt        ; save to EEPROM counter 
                 savedSeqNo     ; saved Sequence No read from EEPROM
                 ess            ; eeprom save state flag                                 
                 FSRsave        ; used to save FSR reg which is usedby two functions.
                 rpwm           ; red pwm level
                 gpwm           ; green pwm level
                 bpwm           ; blue pwm level

	endc

                
;----------------------------------------------------------
; program Constants - DO NOT change them
cTIMER          equ             .179            ; Timer 0 constant 
                                                ; for 5mS timer tick

cHOLDPRESCALER  equ             .10             ; rgb hold counter prescaler
                                                ; 5mS x Prescaler x holdtime
                                                                
cSAVETIMER      equ             .8              ; time after last seq switch change
                                                ; before saving to EEPROM
                                                ; in increments of 1.28S

;----------------------------------------------------------
; GPIO port variables - DO NOT change them
red             equ             0               ;out
green           equ             1               ;out
blue            equ             2               ;out
gpio3           equ             3               ;in (only)
seqSw           equ             5               ;in
                
;----------------------------------------------------------
;
;
; Bank Select macro instructions
#define         setbank0        bcf             STATUS,RP0      ; Sel Bank 0
#define         setbank1        bsf             STATUS,RP0      ; Sel Bank 1
                
                org 0x000
                
                include         RCnavlights_start.inc
                include         RCnavlights_func.inc
                include         RCnavlights_tout.inc
                radix decimal
_base
                ;include         SequenceData.inc
                include         RCnavLightsData.inc

	org 0x2110
;               ------------------------------------------------------------------------
                ; Embed code revision into EEPROM memory
                 de "RCnavlightServo.asm 16/12/2012 R1.0.1"  
                 de "(c) Pete Griffiths 2006-2012 "
                 de "info@picprojects.org.uk"
;               ------------------------------------------------------------------------
                
                ;fill 00, 0x3FF-$
                
                end

