;**********************************************************************
;                                                                     *
;    Filename:              ledcubeC3.asm		              *
;    Date:                  14-January-2011                   	*
;    			                            *
;    Code Version:          1.0.4                                     *
;    Author: Pete Griffiths                                           *
;    Company: picprojects.org.uk                                      *
;                                                                     * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files Required: P16F688.INC                                      *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:                                                           *
;                                                                     *
;             The instruction cycle time is 0.5uS (8Mhz clock)        *
;					*
;	For PCB Revision C			*
;	Schematic: cube555c 23/02/2009		*
;	http://picprojects.org.uk/projects/lc/		*
;             				*
;   V1.0.1                                                            *
;            Added extra instructions to DP (PULLDIS, SWAP)           *
;                                                                     *
;   V1.0.2                                                            *
;            Added extra instructions to DP (DUP, NOT, ROT, OVER)     *
;                                                                     *
;   V1.0.3                                                            *
;            Added diagnostic function for troubleshooting hardware   *
;                                                                     *
;   V1.0.4                                                            *
;            Modify random number generator code                      *
;                                                                     *
;**********************************************************************

	list	p=16f688      	; list directive to define processor
	#include	<P16F688.inc>		; processor specific variable definitions

	
	__CONFIG    _CP_OFF & _CPD_OFF & _BOD_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _MCLRE_ON & _FCMEN_OFF & _IESO_OFF

             errorlevel -302

; '__CONFIG' directive is used to embed configuration data within .asm file.
; The labels following the directive are located in the respective .inc file.
; See respective data sheet for additional information on configuration word.


; ***** EEPROM DATA 
; EEPROM used to hold static code version information.

	ORG	0x2100	; data EEPROM address
	de " LED Cube V1.0.4 C3"
	de " animations 15-01-2011 "
	de " picprojects.org.uk "
	de " (c) 2009-2011 Pete Griffiths "

;***** PROGRAM CONSTANTS

; Timer0 Prescaler 1:8
Ctimer0       equ           .8          ; timer0 reload value 2mS (refresh 100Hz)
;Ctimer0       equ           .132        ; timer0 reload value 1mS (refresh 200Hz)  

; 5 layers x 2mS = 10mS -> 100Hz refresh 
; Changing the refresh will affect the hold and second timers in the lc5x5_inth.inc code                         


;***** VARIABLE DEFINITIONS
                
              cblock  0x20
              buffer.draw:.25	; Drawing buffer
			; Drawing buffer and display buffer must start at the same address
			; in banks 0/1 as program functions expect them to be offset by 128 bytes

	cp.regbase:.4		; command processor General purpose registers
	holdtime	              ; hold time (GPReg 4)   - 30
	vox.x                       ; X axis voxel pointer register (GPReg 5)
	vox.y                       ; Y axis voxel pointer register (GPReg 6)
	vox.z                       ; Z axis voxel pointer register (GPReg 7)
	voxel.count		; Used by SET/CLR/INV ALL drawing functions
	rotate		; temp variable used to rotate cube in the x-axis

	addr.stack.pointer	; instruction pointer stack -35
	user.stack.pointer          ; current stack pointer address
	stack.data.temp             ; temp variable holding value to put on stack
	instruction		; copy of command last fetched
	inst.data		; command data byte

	randomH		; Random number hi byte
	randomL		; Random number lo byte
	mult.mult2                  ; Multiplier to scale random number for use
	mult.resHi                  ; Multiplier to scale random number for use
	mult.resLo                  ; Multiplier to scale random number for use
	math.op1		; math operation variable
	savex		; Temp save of X,Y,Z registers when draw functions
	savey		; use them but they need to be left unchanged on
	savez		; function exit
	lastone
	endc
	
	cblock 0xA0
	buffer.disp:.25	; must be offset from buffer.draw by 128 bytes
	addr.stack:.16	; instruction pointer return address stack
	user.stack:.33	; user software stack
			; user stack is 30 levels deep but the Drawing Processor also
			; makes use of this stack for temporary storage during 
	endc		; instruction exectuion so 3 extra bytes are reserved


	cblock 0x70
	w_temp	              ; variable used for interrupt context saving (also used in startup code)
              status_temp		; variable used for interrupt context saving (also used in startup code)
	pclath_temp		; variable used for interrupt context saving 
	fsr_temp		; variable used for interrupt context saving 
	flag.bit		; Variable used to hold flag bits
	voxel.func		; Variable used to hold voxel mode operations
	shift.register	; Temp variable used to shift drawing buffer data to hardware shift registers
	layer.select		; Variable holds current layer output drive
	shift.count		; Bits shifted counter
	hold.timer		; display update hold timer in 10mS intervals
	tick		; Count of 10mS periods in 1S
	seconds		; Seconds countdown timer
	inst.ptr.Lo		; drawing processor instruction pointer Lo byte 
	inst.ptr.Hi		; drawing processor instruction pointer Hi byte
	char.ptr.Lo		; character data address pointer Lo byte
	char.ptr.Hi		; character data address pointer Hi byte
	endc


; Flag bits
Fcopy.buffer	equ	0	; Set when draw.buffer ready to be transfered to disp.buffer
Fhold.tout	equ	1	; Set when hold delay has completed
Fzero	equ	3	; Flag is set to indicate a value is 0 (zero)
Fcarry	EQU	4	; Flag is set to if add resulted in carry or subtract resulted in borrow

; Voxel function flag bits
Fvoxel.clr	equ	0	; voxel operations will Clear voxels
Fvoxel.set	equ	1	; voxel operations will Set voxels
Fvoxel.inv	equ	2	; voxel operations will Invert voxels
Fcharyz	equ	3	; Character draws in Y plane if set, Z plane if clear


; Port bits on PORTA
controlPort	equ	PORTA
bit.clk	equ	0	; shift register clock  _/
bit.sin	equ	1	; shift register serial in 
bit.latch	equ	2	; shift register latch  \_
bit.switch	equ	4	; switch / SYNCEXT instruction input
bit.testen    equ	5	; Test mode enable (Rev C2 code)

; Port bits on PORTC
layerPort	equ 	PORTC
bit.layer1	equ	0	; LED cube layer drive (Y-axis 0)
bit.layer2	equ	1	; LED cube layer drive (Y-axis 1)
bit.layer3	equ	2	; LED cube layer drive (Y-axis 2)
bit.layer4	equ	3	; LED cube layer drive (Y-axis 3)
bit.layer5	equ	4	; LED cube layer drive (Y-axis 4)
	  

;**********************************************************************
	ORG	0x000		; reset vector
              nop
              clrf          PCLATH        	; 
  	goto	reset.init		; go to initialisation code

	org	0x004		; set PC to interrupt vector 
	#include	lc555_inthPCBC.inc	; interrupt handler code (must live here)
	#include	lc555_draw.inc	; draw functions
	#include	lc555_dp.inc		; Drawing Processor 
	#include      lc555_chardata.inc	; Character drawing data
	#include 	lc555_testmode.inc	; Diagnostic function for hardware troubleshooting
	#include	lc555_reset.inc	; PIC reset initialisation code.	
	#include	lc555_macros.inc	; Display processor instruction definitions
	
	radix dec
program.base.addr			; Drawing Processor user program starts here
	; put drawing processor program include files here
            	#include      CubeProgramJAN11.inc	; Drawing Processor program include file
            	;
	;#include      CubeProgramDev.inc	; Drawing Processor program include file (development)

;------------------------------------------------------------------------


	END                       ; directive 'end of program'

