;--------------------------------------------------------------------------------------
; Initialisation code 

reset.init                    
              clrwdt

	; disable comparators
	movlw         1<<CM0 | 1<<CM1 | 1<<CM2
              movwf         CMCON0
              
              ; change bank register to BANK 1         
              banksel       OPTION_REG
              
              ; configure digital I/O on all ports 
              clrf	ANSEL
              
              ; set internal clock to 8Mhz and wait for it to stablize
              movlw         1<<IRCF2 | 1<<IRCF1 | 1<<IRCF0
              movwf         OSCCON
	;btfss	OSCCON, HTS
	;goto	$-1
                
              ; prescaler to Timer0, TMR0 PS==1:8, Weak Pull-ups enabled
              movlw         (1<<PS1 | 1<<PS0)
              movwf         OPTION_REG    
              
	
              ; set Port A outputs
	movlw	~(1<<bit.clk | 1<<bit.sin | 1<< bit.latch )
	movwf	TRISA
              
              ; Enable weak pull ups on required PortA inputs
              movlw         (1<<bit.switch | 1<<bit.testen)
              movwf         WPUA

              ; change bank register to BANK 0
              banksel       PORTC

              ; initialise all GPRs in bank 0 and 1 to 0x00
              movlw         0x20          ; initialise FSR pointer to GPR start address
              movwf         FSR
              bsf	FSR,7	; set address in bank 1
	clrf          INDF          ; clear GPR pointed to by the FSR
	bcf	FSR,7         ; set address in bank 0     
	clrf          INDF          ; clear GPR pointed to by the FSR
              incf          FSR,F         ; increment FSR pointer
              btfss         FSR,7         ; skip next if bit 7 of FSR set, increment reached 0x80
              goto          $-6           ; else continue clearing GPR

    
	banksel	TRISC
              ; Set Port C outputs
              movlw         ~(1<<bit.layer1 | 1<<bit.layer2 | 1<<bit.layer3 | 1<<bit.layer4 | 1<<bit.layer5)
              movwf         TRISC
	banksel	PORTC
    
	btfss	controlPort, bit.testen
	goto	tm.entry


	; Initialise program code variables
	;
	movlw	buffer.disp
	movwf	fsr_temp

	movlw	0x01
	movwf	layer.select

	bsf	flag.bit, Fhold.tout      

	movlw	HIGH program.base.addr
	movwf	inst.ptr.Hi
	movlw	LOW program.base.addr
	movwf	inst.ptr.Lo

	movlw	user.stack
	movwf	user.stack.pointer
	movlw	addr.stack
	movwf	addr.stack.pointer

	movlw         .1
	movwf         holdtime
	
      	; initialise Timer 0 and enable interrupts
	movlw         Ctimer0
              movwf         TMR0
                            
	movlw	(1<<GIE | 1<<T0IE)
	movwf	INTCON

	; initialisation complete
	; start main code
	goto	inst.load	; in lc555_dp.inc


      

