;**********************************************************************
;                                                                     *
;    Filename:              ledcubeC3_emr.asm                         *
;    Date:                  10-March-2014                   	      *
;    			                                                      *
;    Code Version:          1.0.6                                     *
;    Author: Pete Griffiths                                           *
;    Company: picprojects.org.uk                                      *
;                                                                     * 
;                                                                     *
;**********************************************************************
;    Code will build for either:                                      *
;    Files Required: P16F1824.INC                                     *
;    Files Required: P16F1825.INC                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:                                                           *
;                                                                     *
;    This code must be built as 'absolute' not relocatable            *
;    Project Properties -  mpasm (Global Options)                     *
;                       -  'build in absolute mode' checked           *
;             The instruction cycle time is 0.5uS (8Mhz clock)        *
;                                                                     *
;	For PCB Revision C                                                *
;	Schematic: cube555c 23/02/2009                                    *
;	http://picprojects.org.uk/projects/lc/                            *
;                                                                     *
;   V1.0.1                                                            *
;            Added extra instructions to DP (PULLDIS, SWAP)           *
;                                                                     *
;   V1.0.2                                                            *
;            Added extra instructions to DP (DUP, NOT, ROT, OVER)     *
;                                                                     *
;   V1.0.3                                                            *
;            Added diagnostic function for troubleshooting hardware   *
;                                                                     *
;   V1.0.4                                                            *
;            Modify random number generator code                      *
;                                                                     *
;   V1.0.5   03/03/2014                                               *
;            Updated for enhanced midrange hardare and core.          *
;            Modified to run on the new PIC and not a complete        *
;            rewrite.  Some changes to take advantage of the          *
;            two FSR/INDF index registers.                            *
;                                                                     *
;   V1.0.6   10/03/2014                                               *
;            Couple of small optimizations for enhanced instruction   *
;            set.  Code will assembled for either 16F1824 or 16F1825  *
;            depending on processort selected in project file.        *
;            Two animations file, CubeProgram4K.inc for 16F1823       *
;            CubeProgram8K.inc for 16F1825 (has extra animations)     *
;                                                                     *
;                                                                     *
;**********************************************************************

 IFDEF __16F1824
	list        p=16f1824      	; list directive to define processor
	#include	<P16F1824.inc>	; processor specific variable definitions
 ENDIF

 IFDEF __16F1825
    list        p=16f1825      	; list directive to define processor
	#include	<P16F1825.inc>	; processor specific variable definitions
 ENDIF

    __CONFIG _CONFIG1, 0x3FFF & _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _CPD_OFF & _BOREN_ON & _CLKOUTEN_OFF & _IESO_OFF & _FCMEN_OFF
    __CONFIG _CONFIG2, 0x3FFF & _WRT_OFF & _PLLEN_OFF & _STVREN_OFF & _BORV_19 & _LVP_OFF

    errorlevel -302

; ***** EEPROM DATA 
; EEPROM used to hold static code version information.

	ORG	0xF000	; data EEPROM address
	de " LED Cube V1.0.6 C3"
	de " animations 10-03-2014 "
	de " picprojects.org.uk "
	de " (c) 2009-2014 Pete Griffiths "

;***** PROGRAM CONSTANTS

; Timer0 Prescaler 1:8
Ctimer0       equ           .8          ; timer0 reload value 2mS (refresh 100Hz)
;Ctimer0       equ           .132        ; timer0 reload value 1mS (refresh 200Hz)  

; 5 layers x 2mS = 10mS -> 100Hz refresh 
; Changing the refresh will affect the hold and second timers in the lc5x5_inth.inc code                         


;***** VARIABLE DEFINITIONS
                
              cblock  0x20
                 buffer.draw:.25	; Drawing buffer
                ; Drawing buffer and display buffer must start at the same address
                ; in banks 0/1 as program functions expect them to be offset by 128 bytes

                cp.regbase:.4               ; command processor General purpose registers
                holdtime                    ; hold time (GPReg 4)   - 30
                vox.x                       ; X axis voxel pointer register (GPReg 5)
                vox.y                       ; Y axis voxel pointer register (GPReg 6)
                vox.z                       ; Z axis voxel pointer register (GPReg 7)
                voxel.count                 ; Used by SET/CLR/INV ALL drawing functions
                rotate                      ; temp variable used to rotate cube in the x-axis

                addr.stack.pointer          ; instruction pointer stack -35
                user.stack.pointer          ; current stack pointer address
                stack.data.temp             ; temp variable holding value to put on stack
                instruction                 ; copy of command last fetched
                inst.data                   ; command data byte

                randomH                     ; Random number hi byte
                randomL                     ; Random number lo byte
                mult.mult2                  ; Multiplier to scale random number for use
                mult.resHi                  ; Multiplier to scale random number for use
                mult.resLo                  ; Multiplier to scale random number for use
                math.op1                    ; math operation variable
                savex                       ; Temp save of X,Y,Z registers when draw functions
                savey                       ; use them but they need to be left unchanged on
                savez                       ; function exit
                lastone
                endc

                cblock 0xA0
                buffer.disp:.25             ; must be offset from buffer.draw by 128 bytes
                addr.stack:.16              ; instruction pointer return address stack
                user.stack:.33              ; user software stack
                                            ; user stack is 30 levels deep but the Drawing Processor also
                                            ; makes use of this stack for temporary storage during
                endc                        ; instruction exectuion so 3 extra bytes are reserved


                cblock 0x70
                ;w_temp                     ; variable used for interrupt context saving (also used in startup code)
                ;status_temp                ; variable used for interrupt context saving (also used in startup code)
                ;pclath_temp                ; variable used for interrupt context saving
                FSR1L.inthandler            ; variable used for interrupt context saving
                flag.bit                    ; Variable used to hold flag bits
                voxel.func                  ; Variable used to hold voxel mode operations
                shift.register              ; Temp variable used to shift drawing buffer data to hardware shift registers
                layer.select                ; Variable holds current layer output drive
                shift.count                 ; Bits shifted counter
                hold.timer                  ; display update hold timer in 10mS intervals
                tick                        ; Count of 10mS periods in 1S
                seconds                     ; Seconds countdown timer
                inst.ptr.Lo                 ; drawing processor instruction pointer Lo byte
                inst.ptr.Hi                 ; drawing processor instruction pointer Hi byte
                char.ptr.Lo                 ; character data address pointer Lo byte
                char.ptr.Hi                 ; character data address pointer Hi byte
                endc


; Flag bits
Fcopy.buffer	equ	0          ; Set when draw.buffer ready to be transfered to disp.buffer
Fhold.tout  	equ	1          ; Set when hold delay has completed
Fzero           equ	3          ; Flag is set to indicate a value is 0 (zero)
Fcarry          equ	4          ; Flag is set to if add resulted in carry or subtract resulted in borrow

; Voxel function flag bits
Fvoxel.clr      equ	0              ; voxel operations will Clear voxels
Fvoxel.set      equ	1              ; voxel operations will Set voxels
Fvoxel.inv      equ	2              ; voxel operations will Invert voxels
Fcharyz         equ	3              ; Character draws in Y plane if set, Z plane if clear


; Port bits on PORTA
controlPort     equ	PORTA
bit.clk         equ	0              ; shift register clock  _/
bit.sin         equ	1              ; shift register serial in
bit.latch       equ	2              ; shift register latch  \_
bit.switch      equ	4              ; switch / SYNCEXT instruction input
bit.testen      equ	5              ; Test mode enable (Rev C2and later code)

; Port bits on PORTC
layerPort       equ PORTC
bit.layer1      equ	0              ; LED cube layer drive (Y-axis 0)
bit.layer2  	equ	1              ; LED cube layer drive (Y-axis 1)
bit.layer3      equ	2              ; LED cube layer drive (Y-axis 2)
bit.layer4      equ	3              ; LED cube layer drive (Y-axis 3)
bit.layer5      equ	4              ; LED cube layer drive (Y-axis 4)
	  

;**********************************************************************
	ORG	0x000           ; reset vector
            nop
            clrf        PCLATH        	; 
            goto        reset.init		; go to initialisation code

	org	0x004                           ; set PC to interrupt vector
	#include	lc555_inthPCBC_emr.inc	; interrupt handler code (must live here)
	#include	lc555_draw_emr.inc      ; draw functions
	#include	lc555_dp_emr.inc		; Drawing Processor
	#include    lc555_chardata_emr.inc	; Character drawing data
	#include 	lc555_testmode_emr.inc	; Diagnostic function for hardware troubleshooting
	#include	lc555_reset_emr.inc     ; PIC reset initialisation code.
	#include	lc555_macros_emr.inc	; Display processor instruction definitions
	
	radix dec
program.base.addr                       ; Drawing Processor user program starts here
  
  ; put drawing processor program include files here
  IFDEF __16F1824
    messg "Building for 16F1824 with 4K animation file"
    #include    CubeProgram4K.inc         ; Drawing Processor program include file
  ELSE
    ; Drawing Processor program include file for 16F1825 (Requires 8K program memory)
	messg "Building for 16F1825 with 8K animation file"
    #include    CubeProgram8K.inc
  ENDIF
;------------------------------------------------------------------------


	END                       ; directive 'end of program'

