
; Diagnostic Test Code for troubleshooting hardware problems
; For LEDcubeC
; 26-09-2010
; 03-03-2014 modfied for 16F1824 enhanced midrange PIC

	; Turn off all later drivers and clock in 25 zeroes to the LED
	; current sink drivers chips so all LEDs should be off (if the hardware is working :-/ )

tm.entry        clrf	layerPort


tm.clear        movlw	.25
                movwf	shift.count
                clrf	buffer.draw

tm.shift.loop	call	tm.shift1
                decfsz	shift.count,F
                goto	tm.shift.loop



	; Slow down internal clock to 32Khz which stretches timing on clock signals to shift registers
	; and makes the software delay code easier.

	banksel       OSCCON
                 ; set internal clock to 32Khz
                  movlw         0<<IRCF3 | 0<<IRCF2 | 1<<IRCF1 | 1<<IRCF0
                  movwf         OSCCON
	banksel      layerPort


                ; We now walk a single 'LED' through the cube from layer 1 to layer 5.
                ; all signal transistions to the shift register have a software delay between
                ; them so even a simple resistor and LED, or multimeter will be able to monitor
                ; the transistions on the Layer drive, serial data, serial clock and serial latch signals.

                movlw	.1
                movwf	layer.select
                movwf	layerPort

tm.goround      movlw	.25
                movwf	shift.count

                movlw	.1
                movwf	buffer.draw

tm.next         call	tm.shift1
                decfsz	shift.count,F
                goto	tm.next

                clrc
                rlf	layer.select,W
                btfsc	layer.select,4
                movlw	.1
                movwf	layer.select
                goto	tm.goround

		
tm.shift1       movlw	(0<<bit.clk) | (0<<bit.latch) | (1<<bit.sin)

                decfsz	buffer.draw,F
                andlw	(0<<bit.sin)		; if buffer.draw != 1 clear bit
                movwf	controlPort         ; write to control port
                movwf	buffer.draw

                call	tm.sw.delay

                movfw	buffer.draw
                iorlw	(1<<bit.clk) 		; set clock bit
                movwf	controlPort         ; write to control port, clock data

                call	tm.sw.delay

                movlw	(0<<bit.clk) | (1<<bit.latch) | (0<<bit.sin)
                movwf	controlPort
                movfw	layer.select
                movwf	layerPort

                call	tm.sw.delay

                movlw	(0<<bit.clk) | (0<<bit.latch) | (0<<bit.sin)
                movwf	controlPort

                call	tm.sw.delay



                return


tm.sw.delay     movlw	.255
tm.sw.del.in	addlw	-.1
                skpz
                goto	tm.sw.del.in
                return
