;--------------------------------------------------------------------------------------
; Reset Initialisation code

; msfr MACRO
; loads Wreg with data and writes to specified SFR register
; adding correct bank select instruction if/when required.
; Note: use msfr BSR, bank# to set bank without loading an SFR to ensure
; macro keeps track of current selected bank.

    variable  msfr_currentbank = 0xFFFF ; 0xffff forces intial bank select
msfr   macro sfrname, sfrdata
       local sfrbank

sfrbank = (sfrname / .128) ; divide sfr address by 128 to get bank

       if sfrname == BSR
sfrbank = sfrdata
       endif

       ; if bank for this fsr is not the same as the msfr_currentbank variable
       ; set bank and update variable
       if sfrbank != msfr_currentbank
           movlb sfrbank
msfr_currentbank = sfrbank
       endif


       ; do this unless BSR was specified as SFR register.
       if sfrname != BSR
              movlw         sfrdata
              movwf         sfrname
       endif
       endm

;--------------------------------------------------------------------------------------
reset.init                    
              clrwdt

	; disable comparators
    ; disabled at reset on 16F1824
              
              ; configure digital I/O on all ports
              msfr ANSELA, 0
              msfr ANSELC, 0

              ; set internal clock to 8Mhz and wait for it to stablize
              msfr OSCCON,  1<<IRCF3 | 1<<IRCF2 | 1<<IRCF1 | 0<<IRCF0
              	            
              ; prescaler to Timer0, TMR0 PS==1:8, Weak Pull-ups enabled
              msfr  OPTION_REG,  (0<<WPUA | 1<<PS1 | 1<<PS0)
    
              ; set Port A outputs
              msfr TRISA, ~(1<<bit.clk | 1<<bit.sin | 1<< bit.latch )
	              
              ; Enable weak pull ups on required PortA inputs
              msfr WPUA, (1<<bit.switch | 1<<bit.testen)

              ;-----------------------------------------------------------------------------
              ; initialise all linear GPR to 0x00
              movlw         .160
              movwf         FSR0L
              movlw         0x20            ; initialise FSR0L pointer to GPR start address
              movwf         FSR0H

gprinit.loop  clrf          INDF0
              decfsz        FSR0L,F           ; is FSR0L == 0?
              bra           gprinit.loop
              clrf          INDF0
              clrf          FSR0H           ; ensure these are cleared at reset
              clrf          FSR1H
              ;-----------------------------------------------------------------------------

              ; Set Port C outputs
              msfr TRISC,  ~(1<<bit.layer1 | 1<<bit.layer2 | 1<<bit.layer3 | 1<<bit.layer4 | 1<<bit.layer5)
              
              ; is test mode input low, run test mode function
              msfr  BSR, 0
              btfss     	controlPort, bit.testen
              goto          tm.entry

             ; Initialise program code variables
	         ;
	         ;movlw	buffer.disp
	         ;movwf	FSR0L_temp
             movlw  buffer.disp
             movwf  FSR1L.inthandler

             clrf   voxel.func
             clrf   shift.register
             clrf   shift.count
             clrf   hold.timer
             clrf   tick
             clrf   seconds

	         movlw	0x01
	         movwf	layer.select

             movlw  1<<Fhold.tout
             movwf  flag.bit

             movlw	0x7F & HIGH program.base.addr
             movwf	inst.ptr.Hi
             movlw	LOW program.base.addr
             movwf	inst.ptr.Lo

             movlw	user.stack
             movwf	user.stack.pointer
             movlw	addr.stack
             movwf	addr.stack.pointer
     
             movlw   .1
             movwf   holdtime

             ; initialise Timer 0 and enable interrupts
             msfr   TMR0, Ctimer0
             msfr   INTCON,(1<<GIE | 1<<T0IE)
             
             ; initialisation complete
             ; start main code
             msfr   BSR, 0
             goto	inst.load	; in lc555_dp.inc

             ; end of reset initialisation
             ; ---------------------------

      

