;---------------------------------------------------
;
; Drawing Processor Macro Instruction Definitions
;
; Used upper case to distinguish from PIC assembler instructions
;
; Names cannot be the same as those used by the assembler for
; PIC instructions, directives, operations as assembler is case insensitive.
;
;
;---------------------------------------------------


R0          equ	0
R1          equ	1
R2          equ	2
R3          equ	3
RHOLD       equ	4
RX          equ	5
RY          equ	6
RZ          equ	7


NOOP	macro	
	retlw	0x00
	endm

SKIPZ	macro	
	retlw	0x01
	endm

SKIPNZ	macro	
	retlw	0x02
	endm

SHOW	macro
	retlw	0x03
	endm


MCLR	macro
	retlw	0x04
	endm

MSET	macro
	retlw	0x05
	endm

MINV	macro
	retlw	0x06
	endm


VOXM	macro
	retlw	0x07
	endm


DECX	macro
	retlw	0x08
	endm

DECY	macro
	retlw	0x09
	endm

DECZ	macro
	retlw	0x0A
	endm

RET	macro
	retlw	0x0B
	endm


INCX	macro
	retlw	0x0C
	endm

INCY	macro
	retlw	0x0D
	endm

INCZ	macro
	retlw	0x0E
	endm



CLRALL	macro
	retlw	0x0F
	endm

SETALL	macro
	retlw	0x10
	endm

INVALL	macro
	retlw	0x11
	endm

PUSHXYZ	macro 
	retlw         0x12
	endm

PULLXYZ	macro 
	retlw         0x13
	endm


SHZF	macro
	retlw	0x14
	endm


SHZB	macro
	retlw	0x15
	endm

SHYU	macro
	retlw	0x16
	endm

SHYD	macro
	retlw	0x17
	endm


SHXL	macro
	retlw	0x18
	endm

SHXR	macro
	retlw	0x19
	endm



LINEX	macro
	retlw	0x1A
	endm

LINEY	macro
	retlw	0x1B
	endm

LINEZ	macro
	retlw	0x1C
	endm


PLANEX	macro
	retlw	0x1D
	endm

PLANEY	macro
	retlw	0x1E
	endm

PLANEZ	macro
	retlw	0x1F
	endm

TSTVOX	macro
	retlw	0x20
	endm


RANDSEED	macro
	retlw	0x21
	endm

SKIPTOUT	macro
	retlw	0x22
	endm
	
ROTATEX	macro
	retlw	0x23
	endm
	
XOR	macro
	retlw	0x24
	endm

ADD	macro
	retlw	0x25
	endm

SUB	macro
	retlw	0x26
	endm

AND	macro
	retlw	0x27
	endm

OR 	macro
	retlw	0x28
	endm

SKIPC 	macro
	retlw	0x29
	endm

SKIPNC 	macro
	retlw	0x2A
	endm

TSTSW 	macro
	retlw	0x2B
	endm

DROP 	macro
	retlw	0x2C
	endm

SWAP 	macro
	retlw	0x2D
	endm

DUP 	macro
	retlw	0x2E
	endm

NOT 	macro
	retlw	0x2F
	endm

OVER 	macro
	retlw	0x30
	endm

ROT 	macro
	retlw	0x31
	endm

TSTZ 	macro
	retlw	0x32
	endm

;-------------------------------------------
; register instructions 1byte


DECR	macro Reg
	retlw 0x40 + (0<<3) + Reg
	endm


DECRSZ	macro Reg
	retlw 0x40 + (1<<3) + Reg
	endm
	
	
	
INCR	macro Reg
	retlw 0x40 + (2<<3) + Reg
	endm

INCRSZ	macro Reg
	retlw 0x40 + (3<<3) + Reg
	endm	
	
	

PUSHR	macro Reg
	retlw 0x40 + (4<<3) + Reg
	endm

PULLR	macro Reg
	retlw 0x40 + (5<<3) + Reg
	endm
	
CHYR	macro Reg
	retlw 0x40 + (6<<3) + Reg
	endm
	
CHZR	macro Reg
	retlw 0x40 + (7<<3) + Reg
	endm

;---------------------------------------------
; Load XYZ instructions
; and 2 byte data instructions

LDXYZ        macro x,y,z
              retlw 0x80 + (.0<<1) + (x>>2)
	retlw ((x&3)<<6) + (y<<3) + z
	endm

VOX	macro x,y,z
	retlw 0x80 + (.1<<1) + (x>>2)
	retlw ((x&3)<<6) + (y<<3) + z
	endm


LINE	macro xdir,ydir,zdir,length
	
xval set 0
yval set 0
zval set 0

 if xdir==1
xval set 1<<3
 endif
 if ydir==1
yval set 1<<4
 endif	
 if ydir==-1
yval set 1<<5
 endif	
 if zdir==1
zval set 1<<6
 endif	
 if zdir==-1
zval set 1<<7
 endif

 if xdir==-1
   retlw	0x80 + (2<<1)	+ 1
 else
   retlw	0x80 + (2<<1)	
 endif

   retlw	zval | yval | xval | (length & 0x07)
 endm





CHY	macro Char
	retlw 0x80 + (.3<<1)
	retlw Char
	endm

CHZ	macro Char
	retlw 0x80 + (.4<<1)
	retlw Char
	endm

LDTMR	macro Seconds
	retlw 0x80 + (.5<<1)
	retlw Seconds
	endm

ADDTRND	macro MaxRandVal
	retlw 0x80 + (.6<<1)
	retlw MaxRandVal
	endm

SYNCEXT	macro SyncTimeout
	retlw 0x80 + (.7<<1)
	retlw SyncTimeout
	endm
;--------------------------------------------
; 2 byte register instructions

LDR	macro Reg, Rdata
	retlw 0xA0 + (.0<<3) + Reg
	retlw Rdata
	endm

LDRAND       macro Reg, Rdata
	retlw 0xA0 + (.1<<3) + Reg
	retlw Rdata
	endm

CMP          macro Reg, Compare
	retlw 0xA0 + (.2<<3) + Reg
	retlw Compare
	endm





;---------------------------------------------
; Address payload commands
; The enhanced midrange parts have access to program memory
; using the FSR indirect register starting at 0x8000.  When
; the assembler sees an address label in the code it
; adds 0x8000 to the address.  However, this legacy code
; doesn't expect that so it is masked out with 0x7F

JSR	macro CallAddr
	retlw 0xE0 + (0x7F & HIGH CallAddr)
	retlw (LOW CallAddr)
	endM

JUMP	macro JumpAddr
	retlw 0xC0 + (0x7F & HIGH JumpAddr)
	retlw (LOW JumpAddr)
	endM


;---------------------------------------------

