;----------------------------------------------------------
; 5x5x5 LED Cube display driver
; Interrupt Handler:
;  Display refresh shift register loader and level driver.
;  Timer functions
; Notes;
;  Shift register output code for LED arrangement on PCB500C
;  and output driver device type STP16CP05
;
;----------------------------------------------------------


            if ( $ != 0x004)
             ;error "*********************************************************"
             ;error " Start of interrupt handler code is not located at "
             ;error " interrupt vector address 0x004 - please correct "
             ;error "*********************************************************"
            endif

            ; located at address 0x004

            clrf        PCLATH
            clrf        FSR1H               ; FSR registers are saved by automatic interrupt context saving
                                            ; so we must initialise it FSR1H inside ISR
            banksel 	TMR0
            movlw       Ctimer0
            addwf       TMR0,F
            bcf         INTCON, T0IF

            movfw       FSR1L.inthandler
            movwf       FSR1L
            call        disp.multiplex
            movfw       FSR1L
            movwf       FSR1L.inthandler

            retfie                      	; return from interrupt


;-----------------------------------------------------
; Interrupt driven display refresh will update one layer with data from the display buffer
; on each interrupt.
;
; A transfer of data from the draw.buffer is requested by setting the copy.buffer flag.
; At the next complete layer refresh cycle, if the copy.buffer flag is set the draw buffer
; is copied into the display buffer and the flag cleared.
;
; Value in FSR0L register is restored/saved between interrupts


disp.multiplex
            clrf	layerPort
            call	sr.load
            clrc
            rlf     layer.select,F	; select next layer
            btfss	layer.select,5	; test for bit 1 more than layers 0 to 4
            return

;-----------------------------------------	
disp.init	btfss	flag.bit, Fcopy.buffer
            bra   	disp.setbuffer
;-----------------------------------------
; This code overwrites the FSR0L register so we only run it, if needed, at the end
; of one complete display refresh since at this point we reset the FSR0L to point to
; the start of the buffer.disp anyway so overwritting the FSR0L doesn't matter.
;
copy.buffer	movlw	buffer.draw	
            movwf	FSR1L
            movlw	.25
            movwf	shift.count
copy.buffer.loop
            bcf     FSR1L,7
            movfw	INDF1
            bsf     FSR1L, 7
            movwf	INDF1
            incf	FSR1L,F
            decfsz	shift.count,F
            bra  	copy.buffer.loop

            bcf     flag.bit, Fcopy.buffer	; clear copy.buffer flag
;-----------------------------------------

disp.setbuffer
            movlw	buffer.disp		; load W with base address of buffer.disp
            movwf	FSR1L           ; initialise FSR0L with base address of buffer
            movlw	.1              ; reset layer drive pointer
            movwf	layer.select
	
	
            ; Interrupt period is 2mS
            ; Display has 5 layers so we arrive here once every 5 x 2mS = 10mS
	
            ; Update the hold timer
utimer.dec	movf	hold.timer,F		; test hold.timer for 0
            skpnz                       ; skip if hold.timer != 0
            bra     tick.dec

            decf	hold.timer,F		; decrement hold.timer
            skpnz                       ; skip if hold.timer != 0
tick.dec	bsf     flag.bit, Fhold.tout	; set timeout flag
	
            ; Update the user program seconds timer
            decfsz	tick,F              ; decrement tick counts
            return                      ; return if stil counting

            movlw	.100                ; reload tick
            movwf	tick
            movf	seconds,F           ; test seconds
            skpz                        ; skip next if seconds count == zero
            decf	seconds,F       	; else decrement seconds count
            return


;-----------------------------------------	
sr.load	; shift 5 X-voxels into the 5 Z-axis rows

;	order of LEDs in matrix
;
;   	21 22 23 24 25   Z4
;       16 17 18 19 20   Z3
;       11 12 13 14 15   Z2
;       6  7  8  9 10   Z1
;       1  2  3  4  5   Z0
;       ---------------
;   X-> 0  1  2  3  4
;
;	Physical connection of LEDs to shift register outputs
;	----------------__---> shift direction ------------------------->
;	25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9 8 7 6 5 4 3 2 1

            call	sr.out	; shift Z0
            call	sr.out	; shift Z1
            call	sr.out	; shift Z2
            call	sr.out	; shift Z3
            call	sr.out	; shift Z4
            ; Toggle Shift Register output latch
            ; Code is written for STP16CP05 Low voltage 16-bit constant current LED sink driver
            ; but it can easily be modified to work with other shift register arrangements.
            ;
            ; bit.clk   is Shift Register Clk input  (Serial Data is clocked in on rising edge)
            ; bit.latch is Shift Register Latch Enable input  (Serial data is latched when low)
            ; bit.sin   is Shift Register Serial Data input

            movlw	(0<<bit.clk) | (1<<bit.latch) | (0<<bit.sin)
            movwf	controlPort
            movlw	(0<<bit.clk) | (0<<bit.latch) | (0<<bit.sin)
            movwf	controlPort
            ; activate current layer (Y axis) drive transistor output
            movfw	layer.select
            movwf	layerPort

            return

;-----------------------------------------	
sr.out      movlw	.5                  ; initialise shift count
            movwf	shift.count         ; for 5 X-voxel bits
            rlf     INDF1,W             ; copy X-voxel data in temporary
                                        ; realign data to left of byte before shifting out due to hardware arrangement
                                        ; of LED matrix.
            movwf	shift.register      ; register for shifting out
            rlf     shift.register,F	; register for shifting out
            rlf     shift.register,F	; register for shifting out

sr.loop     movlw	(0<<bit.clk) | (0<<bit.latch) | (0<<bit.sin)
            rlf     shift.register,F
            skpnc
            iorlw	(1<<bit.sin)		; if voxel is a 1 set bit
            movwf	controlPort         ; write to control port
            iorlw	(1<<bit.clk) 		; set clock bit
            movwf	controlPort         ; write to control port, clock data
            decfsz	shift.count,F		; test and loop for all 5 X-voxel bits.
            bra  	sr.loop
            incf	FSR1L,F             ; point to next Z row
            return





	
