char.base.addr

; 5x5 Character Set
; The following ASCII characters are defined in this file
;--------------------------------------------------------
;Chr Dec Hex Name  
;----------------
;SP  32  20  Space  
;!   33  21  Exclamation mark  
;"   34  22  Quotation mark
;#   35  23  Cross hatch (number sign)  
;$   36  24  Dollar sign  
;%   37  25  Percent sign  
;&   38  26  Ampersand  
;`   39  27  Closing single quote (apostrophe)  
;(   40  28  Opening parentheses  
;)   41  29  Closing parentheses  
;*   42  2a  Asterisk (star)
;+   43  2b  Plus  
;,   44  2c  Comma  
;-   45  2d  Hyphen, dash, minus  
;.   46  2e  Period  
;/   47  2f  Slant (forward slash, divide)  
;--------------------------------------
;
; 0,1,2,3,4,5,6,7,8,9  48-58 30-39 Numbers
;
;--------------------------------------
;:   58  3a  Colon  
;;   59  3b  Semicolon  
;<   60  3c  Less than sign 
;=   61  3d  Equals sign  
;>   62  3e  Greater than sign  
;?   63  3f  Question mark  
;@   64  40  At-sign  
;--------------------------------------
;
; A - Z   65-90 41-5a  Uppercase letters 
;
;--------------------------------------
;[  91  5b  Opening square bracket  
;\  92  5c  Reverse slant (Backslash)  
;]  93  5d  Closing square bracket  
;^  94  5e  Caret (Circumflex)  
;_  95  5f  Underscore
;-------------------------------------



	; Space
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'00000'
	
	; !
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00000'
	retlw	b'00100'
	
	; "
	retlw	b'01010'
	retlw	b'01010'
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'00000'
	
	; #
	retlw	b'01010'
	retlw	b'11111'
	retlw	b'01010'
	retlw	b'11111'
	retlw	b'01010'
	
	; $
	retlw	b'01111'
	retlw	b'10100'
	retlw	b'01110'
	retlw	b'00101'
	retlw	b'11110'
	
	; %
	retlw	b'11001'
	retlw	b'11010'
	retlw	b'00100'
	retlw	b'01011'
	retlw	b'10011'
	
	; &
	retlw	b'01000'
	retlw	b'10100'
	retlw	b'01101'
	retlw	b'10010'
	retlw	b'01101'
	
	; '
	retlw	b'01100'
	retlw	b'01100'
	retlw	b'00100'
	retlw	b'01000'
	retlw	b'00000'
	
	; (
	retlw	b'00010'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00010'
	
	; )
	retlw	b'01000'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'01000'
	
	; *
	retlw	b'10101'
	retlw	b'01110'
	retlw	b'11111'
	retlw	b'01110'
	retlw	b'10101'

	; +
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'11111'
	retlw	b'00100'
	retlw	b'00100'

	; ,
	retlw	b'00000'
	retlw	b'01100'
	retlw	b'01100'
	retlw	b'00100'
	retlw	b'01000'
	
	; -
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'11111'
	retlw	b'00000'
	retlw	b'00000'

	; .
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'01100'
	retlw	b'01100'

	; /
	retlw	b'00001'
	retlw	b'00010'
	retlw	b'00100'
	retlw	b'01000'
	retlw	b'10000'

;--------------------------------------
; Numbers
	;0
	retlw	b'01110'
	retlw	b'10011'
	retlw	b'10101'
	retlw	b'11001'
	retlw	b'01110'
	;1
	retlw	b'00100'
	retlw	b'01100'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'01110'
	;2
	retlw	b'11110'
	retlw	b'00001'
	retlw	b'00110'
	retlw	b'01000'
	retlw	b'11111'
	;3
	retlw	b'11110'
	retlw	b'00001'
	retlw	b'01110'
	retlw	b'00001'
	retlw	b'11110'
	;4
	retlw	b'00110'
	retlw	b'01010'
	retlw	b'11111'
	retlw	b'00010'
	retlw	b'00010'
	;5
	retlw	b'11111'
	retlw	b'10000'
	retlw	b'11110'
	retlw	b'00001'
	retlw	b'11110'
	;6
	retlw	b'00110'
	retlw	b'01000'
	retlw	b'11110'
	retlw	b'10001'
	retlw	b'01110'
	;7
	retlw	b'11111'
	retlw	b'00010'
	retlw	b'00100'
	retlw	b'01000'
	retlw	b'01000'
	;8
	retlw	b'01110'
	retlw	b'10001'
	retlw	b'01110'
	retlw	b'10001'
	retlw	b'01110'
	;9
	retlw	b'01110'
	retlw	b'10001'
	retlw	b'01111'
	retlw	b'00010'
	retlw	b'01100'
	
;--------------------------------------
;: 72 58 3a Colon  
;; 73 59 3b Semicolon  
;< 74 60 3c Less than sign (&lt; in HTML)  
;= 75 61 3d Equals sign  
;> 76 62 3e Greater than sign (&gt; in HTML)  
;? 77 63 3f Question mark  
;@ 100 64 40 At-sign  

	; :
	retlw	b'01100'
	retlw	b'01100'
	retlw	b'00000'
	retlw	b'01100'
	retlw	b'01100'
	
	; ;
	retlw	b'01100'
	retlw	b'00000'
	retlw	b'01100'
	retlw	b'00100'
	retlw	b'01000'
	
	; <
	retlw	b'00010'
	retlw	b'00100'
	retlw	b'01000'
	retlw	b'00100'
	retlw	b'00010'
	
	; =
	retlw	b'00000'
	retlw	b'11111'
	retlw	b'00000'
	retlw	b'11111'
	retlw	b'00000'
	
	; >
	retlw	b'01000'
	retlw	b'00100'
	retlw	b'00010'
	retlw	b'00100'
	retlw	b'01000'
	
	; ?    
	retlw	b'01110'
	retlw	b'10001'
	retlw	b'00010'
	retlw	b'00100'
	retlw	b'00100'
	
	; @    
	retlw	b'01110'
	retlw	b'10101'
	retlw	b'10111'
	retlw	b'10000'
	retlw	b'01110'
	
;--------------------------------------
; A-Z

	; A
	retlw	b'00100'
	retlw	b'01010'
	retlw	b'11111'
	retlw	b'10001'
	retlw	b'10001'
	
	; B
	retlw	b'11110'
	retlw	b'01001'
	retlw	b'01110'
	retlw	b'01001'
	retlw	b'11110'

	; C
	retlw	b'01111'
	retlw	b'10000'
	retlw	b'10000'
	retlw	b'10000'
	retlw	b'01111'
	
	; D
	retlw	b'11110'
	retlw	b'01001'
	retlw	b'01001'
	retlw	b'01001'
	retlw	b'11110'
	
	; E
	retlw	b'11111'
	retlw	b'10000'
	retlw	b'11110'
	retlw	b'10000'
	retlw	b'11111'
	
	; F
	retlw	b'11111'
	retlw	b'10000'
	retlw	b'11110'
	retlw	b'10000'
	retlw	b'10000'
	
	; G
	retlw	b'01111'
	retlw	b'10000'
	retlw	b'10011'
	retlw	b'10001'
	retlw	b'01111'
	
	; H
	retlw	b'10001'
	retlw	b'10001'
	retlw	b'11111'
	retlw	b'10001'
	retlw	b'10001'
	
	; I
	retlw	b'01110'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'01110'
	
	; J
	retlw	b'00001'
	retlw	b'00001'
	retlw	b'00001'
	retlw	b'10001'
	retlw	b'01110'
	
	; K
	retlw	b'10011'
	retlw	b'10100'
	retlw	b'11000'
	retlw	b'10100'
	retlw	b'10011'
	
	; L
	retlw	b'10000'
	retlw	b'10000'
	retlw	b'10000'
	retlw	b'10000'
	retlw	b'11111'
	
	; M
	retlw	b'10001'
	retlw	b'11011'
	retlw	b'10101'
	retlw	b'10001'
	retlw	b'10001'
	
	; N
	retlw	b'10001'
	retlw	b'11001'
	retlw	b'10101'
	retlw	b'10011'
	retlw	b'10001'
	
	; O
	retlw	b'01110'
	retlw	b'10001'
	retlw	b'10001'
	retlw	b'10001'
	retlw	b'01110'
	
	; P
	retlw	b'11110'
	retlw	b'10001'
	retlw	b'11110'
	retlw	b'10000'
	retlw	b'10000'
	
	; Q
	retlw	b'01100'
	retlw	b'10010'
	retlw	b'10110'
	retlw	b'10010'
	retlw	b'01101'
	
	; R
	retlw	b'11110'
	retlw	b'10001'
	retlw	b'11110'
	retlw	b'10100'
	retlw	b'10010'
	
	; S
	retlw	b'01111'
	retlw	b'10000'
	retlw	b'01110'
	retlw	b'00001'
	retlw	b'11110'
	
	; T
	retlw	b'11111'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00100'
	
	; U
	retlw	b'10001'
	retlw	b'10001'
	retlw	b'10001'
	retlw	b'10001'
	retlw	b'01110'
	
	; V
	retlw	b'10001'
	retlw	b'10001'
	retlw	b'10001'
	retlw	b'01010'
	retlw	b'00100'
	
	; W
	retlw	b'10001'
	retlw	b'10001'
	retlw	b'10101'
	retlw	b'11011'
	retlw	b'10001'
	
	; X
	retlw	b'10001'
	retlw	b'01010'
	retlw	b'00100'
	retlw	b'01010'
	retlw	b'10001'
	
	; Y
	retlw	b'10001'
	retlw	b'01010'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00100'
	
	; Z
	retlw	b'11111'
	retlw	b'00010'
	retlw	b'00100'
	retlw	b'01000'
	retlw	b'11111'
	
;--------------------------------------
;[  91 5b Opening square bracket  
;\  92 5c Reverse slant (Backslash)  
;]  93 5d Closing square bracket  
;^  94 5e Caret (Circumflex)  
;_  95 5f Underscore  
	
	; [
	retlw	b'00111'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00111'
	
	; \    
	retlw	b'10000'
	retlw	b'01000'
	retlw	b'00100'
	retlw	b'00010'
	retlw	b'00001'
	
	; ]
	retlw	b'11100'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'00100'
	retlw	b'11100'
	
	; ^
	retlw	b'00100'
	retlw	b'01010'
	retlw	b'10001'
	retlw	b'00000'
	retlw	b'00000'
	
	; _
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'00000'
	retlw	b'11111'
	
	
	
