
	RANDSEED	

	TSTSW	; If switch pressed at start run animations in sequence
	SKIPNZ
	JUMP	RUN.IN.SEQUENCE

;---------------------------------------------------------
; Run animations using random selection
; This is default mode at power on
; 

	; Always run the picprojects animation test at power-on

	JSR	PICPROJECTS

SELECT_PROG
	LDR RHOLD,9
	LDRAND	R0,35	; number of animations + 1
	INCR	R0
	JSR	SELECT_LOOP
	JUMP	SELECT_PROG

SELECT_LOOP	
	DECR R0
	SKIPNZ
	JUMP	HELIX	;1
	DECR R0
	SKIPNZ
	JUMP	SANDL	;2
	DECR R0
	SKIPNZ
	JUMP	SPEARS	;3
	DECR R0
	SKIPNZ
	JUMP	CONVERGE	;4
	DECR R0
	SKIPNZ
	JUMP	DIAMOND	;5
	DECR R0
	SKIPNZ
	JUMP	BUBBLES	;6
	DECR R0
	SKIPNZ
	JUMP	CUBEYDO	;7
	DECR R0
	SKIPNZ
	JUMP	FRANTIC	;8
	DECR R0
	SKIPNZ
	JUMP	SPINNER	;9
	DECR R0
	SKIPNZ
	JUMP	BOXIT	;10
	DECR R0
	SKIPNZ
	JUMP	CUBEFILL_TR	;11
	DECR R0
	SKIPNZ	
	JUMP	CUBEFILL_BL	;12
	DECR R0
	SKIPNZ
	JUMP	THING	;13
	DECR R0
	SKIPNZ
	JUMP	DGTHING	;14

	DECR R0
	SKIPNZ
	JUMP	WAVEX	;15

	DECR R0
	SKIPNZ
	JUMP	WAVEY	;16
		
	DECR R0
	SKIPNZ
	JUMP	WAVEZ	;17

	DECR R0
	SKIPNZ
	JUMP	STRIP.LAYERS	;18

	DECR R0
	SKIPNZ
	JUMP	FILLnWIPE	;19

	DECR R0
	SKIPNZ
	JUMP	BOUNCE.IT	;20

	DECR R0
	SKIPNZ
	JUMP	WIGGLE	;21

	DECR R0
	SKIPNZ
	JUMP	XLINE	;22

	DECR R0
	SKIPNZ
	JUMP	THEFLY	;23

	DECR R0
	SKIPNZ
	JUMP	SPEEDY.DOT	;24

	DECR R0
	SKIPNZ	
	JUMP	CUBE_DISSOLVE	;25

	DECR R0
	SKIPNZ
	JUMP	ARROW_HEAD	;26

	DECR R0
	SKIPNZ
	JUMP	COUNTDOWN	;27

	DECR R0
	SKIPNZ
	JUMP	SPIRAL	;28


;JB - 8K MEMORY EXTRAS
    DECR R0
    SKIPNZ
    JUMP    SPRAY   ;29

    DECR R0
    SKIPNZ
    JUMP    SLOWSHOW    ;30

    DECR R0
    SKIPNZ
    JUMP    ROTAX   ;31

    DECR R0
    SKIPNZ
    JUMP    BOUNCE_FILL ;32

    DECR R0
    SKIPNZ
    JUMP    MAGNET  ;33

    DECR R0
    SKIPNZ
    JUMP    MYHELIX ;34


	JUMP	SELECT_LOOP


;---------------------------------------------------------
; Run animations sequentialy
; This mode runs if S1 switch was pressed at power-on
RUN.IN.SEQUENCE
	JSR	PICPROJECTS
RUN.IN.SEQ.LOOP

	JSR	HELIX
	JSR	SANDL
	JSR	SPEARS
	JSR	CONVERGE
	JSR	DIAMOND
	JSR	BUBBLES	
	JSR	CUBEYDO
	JSR	FRANTIC
	JSR	SPINNER
	JSR	BOXIT
	JSR	CUBEFILL_TR
	JSR	CUBEFILL_BL
	JSR	THING
	JSR	DGTHING
	JSR	WAVEX
	JSR	WAVEY
	JSR	WAVEZ
	JSR	STRIP.LAYERS
	JSR	FILLnWIPE
	JSR	BOUNCE.IT
	JSR	WIGGLE
	JSR	XLINE
	JSR	THEFLY
	JSR	SPEEDY.DOT	;24
	JSR	CUBE_DISSOLVE	;25
	JSR	ARROW_HEAD	;26
	JSR	COUNTDOWN	;27
	JSR	SPIRAL      ;28

    JSR SPRAY       ;29
    JSR SLOWSHOW    ;30
    JSR ROTAX       ;31
    JSR BOUNCE_FILL ;32
    JSR MAGNET      ;33
    JSR MYHELIX     ;34

	JUMP	RUN.IN.SEQ.LOOP




;---------------------------------------------------------
; End of sequence hold timeout, use by multiple animations
END_WAIT	SKIPTOUT
	JUMP	END_WAIT
	RET
;--------------------------------------------------------
; PICPROJECTS text animation
PICPROJECTS

	LDR RZ,4
	MSET
	LDR R0, 'P'
	JSR WRITE
	LDR R0, 'I'
	JSR WRITE
	LDR R0, 'C'
	JSR WRITE
	LDR R0, 'P'
	JSR WRITE
	LDR R0, 'R'
	JSR WRITE
	LDR R0, 'O'
	JSR WRITE
	LDR R0, 'J'
	JSR WRITE
	LDR R0, 'E'
	JSR WRITE
	LDR R0, 'C'
	JSR WRITE
	LDR R0, 'T'
	JSR WRITE
	LDR R0, 'S'
	JSR WRITE
	LDR R0, ' '
	JSR WRITE
	LDR R0, '8'
	JSR WRITE
	LDR R0, 'K'
	JSR WRITE	
	RET

WRITE	LDR RHOLD,8
	CLRALL
	CHYR R0
	SHOW
	SHZF
	SHOW
	SHZF
	SHOW
	SHZF
	SHOW
	SHZF
	LDR RHOLD,35
	SHOW
	RET



;----------------------------------------
HELIX	LDR	RHOLD,9
	LDTMR	5
	ADDTRND	7
	MSET

HELIX_LOOP	CLRALL
	LDXYZ 0,0,0
	LINE 1,1,0,5
	;-----------
	LDXYZ 4,0,4
	LINE -1,1,0,5
	SHOW

	CLRALL
	LDXYZ 1,0,0
	LINE 1,1,0,4
	VOX 4,4,1
	;-----------
	LDXYZ 3,0,4
	LINE -1,1,0,4
	VOX 0,4,3	
	SHOW

	CLRALL
	LDXYZ 2,0,0
	LINE 1,1,0,3
	LDXYZ 4,3,1
	LINE 0,1,1,2
	;-----------
	LDXYZ 2,0,4
	LINE -1,1,0,3
	LDXYZ 0,3,3
	LINE 0,1,-1,2
	SHOW
	CLRALL

	LDXYZ 3,0,0
	LINE 1,1,0,2
	LDXYZ 4,2,1
	LINE 0,1,1,3
	;-----------
	LDXYZ 1,0,4
	LINE -1,1,0,2
	LDXYZ 0,2,3
	LINE 0,1,-1,3
	SHOW
	CLRALL

	LDXYZ 4,0,0
	LINE 0,1,1,5
	;-----------
	LDXYZ 0,0,4
	LINE 0,1,-1,5
	SHOW
	CLRALL
	
	LDXYZ 4,0,1
	LINE 0,1,1,4
	VOX 3,4,4
	;-----------
	LDXYZ 0,0,3
	LINE 0,1,-1,4
	VOX 1,4,0
	SHOW
	CLRALL

	LDXYZ 4,0,2
	LINE 0,1,1,3
	LDXYZ 3,3,4
	LINE -1,1,0,2
	;------------
	LDXYZ 0,0,2
	LINE 0,1,-1,3
	LDXYZ 1,3,0
	LINE 1,1,0,2
	SHOW
	CLRALL

	LDXYZ 4,0,3
	LINE 0,1,1,2
	LDXYZ 3,2,4
	LINE -1,1,0,3
	;------------
	LDXYZ 0,0,1
	LINE 0,1,-1,2
	LDXYZ 1,2,0
	LINE 1,1,0,3
	SHOW

	SKIPTOUT	
	JUMP HELIX_LOOP
	RET

;---------------------------------
SANDL	
          	LDR RHOLD,1
	CLRALL
          	MSET
	LDXYZ 0,0,0
	PLANEY
	SHOW
	LDTMR 10

SANDL_LOOP
	LDR RHOLD, 15
	SHOW
	
	LDRAND RX,5
	LDRAND RZ,5
	LDR RY,0
	LDR R0,4
	LDR RHOLD, 5

	TSTVOX
	SKIPZ
	JUMP	SANDL_MOVUP
	LDR RY,4

SANDL_MOVDOWN
	MCLR
	VOXM
	DECY
	MSET
	VOXM
	SHOW
	DECRSZ R0
	JUMP	SANDL_MOVDOWN
	JUMP	SANDL_DONE

SANDL_MOVUP
	MCLR
	VOXM
	INCY
	MSET
	VOXM
	SHOW
	DECRSZ R0
	JUMP	SANDL_MOVUP
	JUMP 	SANDL_DONE

SANDL_DONE	SKIPTOUT
	JUMP SANDL_LOOP
	RET

;---------------------------------------	
SPEARS
	LDTMR 10
	CLRALL
	SHOW
	LDR R1,0
	PUSHR R1

SPEAR_LOOP
	LDR RHOLD,3
	LDRAND RX,5
	LDRAND RY,5
	LDRAND RZ,5

	LDRAND R1,6
	
	PULLR R0
	PUSHR R0

	PUSHR R1
	XOR
	DROP
	SKIPNZ
	JUMP SPEAR_LOOP
	PUSHR R1
	

	CMP R1,0
	SKIPNZ
	LDR RX,0
	CMP R1,1
	SKIPNZ
	LDR RY,0
	CMP R1,2
	SKIPNZ
	LDR RZ,0

	CMP R1,3
	SKIPNZ
	LDR RX,4
	CMP R1,4
	SKIPNZ
	LDR RY,4
	CMP R1,5
	SKIPNZ
	LDR RZ,4


	MSET
	LDR R0,5
	JSR SPEAR_NEXT
	MCLR	
	LDR R0,5
	JSR SPEAR_NEXT

	SHOW
	SKIPTOUT
	JUMP SPEAR_LOOP
	RET

SPEAR_NEXT	
	VOXM
	SHOW
	CMP R1,0
	SKIPNZ
	INCX
	CMP R1,1
	SKIPNZ
	INCY
	CMP R1,2
	SKIPNZ
	INCZ

	CMP R1,3
	SKIPNZ
	DECX
	CMP R1,4
	SKIPNZ
	DECY
	CMP R1,5
	SKIPNZ
	DECZ


	DECRSZ R0
	JUMP SPEAR_NEXT
	RET
;-----------------------------------------

CONVERGE
	
	CLRALL
            	SHOW
	MSET
	LDR RHOLD, 35

	VOX 0,0,0
	VOX 4,0,0
	VOX 4,4,0
	VOX 4,4,4
	VOX 0,4,4
	VOX 0,0,4
	VOX 4,0,4
	VOX 0,4,0
	SHOW

	VOX 1,1,1
	VOX 1,1,3
	VOX 1,3,1
	VOX 1,3,3
	VOX 3,1,1
	VOX 3,1,3
	VOX 3,3,1
	VOX 3,3,3
	SHOW

	VOX 2,2,2
	SHOW
	CLRALL
	JUMP	END_WAIT

;-------------------------------------
DIAMOND
	LDR	RHOLD, 50
	CLRALL
 	MSET	
	VOX 2,2,2
	SHOW

	VOX 2,1,2
	VOX 2,3,2
	VOX 1,2,2
	VOX 3,2,2
	VOX 2,2,1
	VOX 2,2,3
	SHOW
	
	LDXYZ 2,2,2
	LINEX
	LINEY
	LINEZ

	VOX 1,2,1
	VOX 3,2,3
	VOX 1,2,3
	VOX 3,2,1

	VOX 2,1,1
	VOX 2,1,3
	VOX 1,1,2
	VOX 3,1,2

	VOX 2,3,1
	VOX 2,3,3
	VOX 1,3,2
	VOX 3,3,2
	SHOW
	LDTMR 1
	JUMP END_WAIT

;-----------------------------------------
BUBBLES

         	LDR RHOLD,7
    	LDTMR 15
	LDR RY,0	
	CLRALL
	MSET
                                
BUBBLE_LOOP
	SHYU
              JSR BUBBLE_MAKE
              SHOW
        
              SKIPTOUT
              JUMP BUBBLE_LOOP
              RET   
          
BUBBLE_MAKE

	LDRAND RX,5
	LDRAND RZ,5
              VOXM
              RET


;--------------------------------------
CUBEYDO
	CLRALL
	LDR RHOLD, 15
	MSET
	LDXYZ 0,0,0
	LINEX
	LDXYZ 0,0,4
	LINEX
	SHOW
	LINEZ
	LDXYZ 4,0,0
	LINEZ
	SHOW



	LDR RY,0	
CUBEYDO.LOOP1	LDR RX,0
	LDR RZ,0
	VOXM
	DECX
	VOXM
	DECZ
	VOXM
	INCX
	VOXM
	SHOW
	INCY
	CMP RY,0
	SKIPZ
	JUMP	CUBEYDO.LOOP1

	LDXYZ 2,4,2
	PLANEY
	MCLR
	LINEX
	LINEZ
	SHOW
	MSET
	PLANEY
	SHOW
	SHYD
	SHOW
	SHYD
	SHOW
	SHYD
	SHOW
	SHYD
	SHOW

	SHYU
	SHOW
	SHYU
	SHOW
	
	CLRALL
	LDXYZ 0,2,0
	LINE 1,0,0,5
	LINE 0,0,1,5
	LINE -1,0,0,5
	LINE 0,0,-1,5

	LDXYZ 1,3,1
	LINE 1,0,0,3
	LINE 0,0,1,3
	LINE -1,0,0,3
	LINE 0,0,-1,3
	SHOW

	VOX 2,4,2
	SHOW

	CLRALL
	VOX 2,4,2
	DECY
	PLANEY
	MCLR
	VOX 2,3,2
	SHOW
	INCY
	CLRALL
	MSET
	PLANEY
	SHOW

	MCLR
	VOX 0,4,0
	VOX 4,4,0
	VOX 4,4,4
	VOX 0,4,4
	MSET
	VOX 0,3,0
	VOX 4,3,0
	VOX 4,3,4
	VOX 0,3,4
	SHOW

	CLRALL
	LDXYZ 2,4,2
	LINEX
	LINEZ
	VOX 1,4,1
	VOX 1,4,3
	VOX 3,4,3
	VOX 3,4,1

	VOX 1,3,0
	VOX 0,3,1

	VOX 3,3,0
	VOX 4,3,1

	VOX 4,3,3
	VOX 3,3,4

	VOX 1,3,4
	VOX 0,3,3
	
	VOX 0,2,0
	VOX 4,2,0
	VOX 4,2,4
	VOX 0,2,4

	SHOW
	SHYD
	MCLR
	VOX 1,3,2
	VOX 2,3,1
	VOX 3,3,2
	VOX 2,3,3	
	VOX 2,3,2
	
	MSET
	VOX 1,4,2
	VOX 2,4,1
	VOX 3,4,2
	VOX 2,4,3	
	VOX 2,4,2
	SHOW
	SHYD
	MCLR
	VOX 2,3,2
	MSET
	VOX 2,4,2
	SHOW
	SHYD
	SHOW
	SHYD
	SHOW
	SHYD
	SHOW
	SHYD
	SHOW
	SHYD
	SHOW
	RET
;---------------------------------------------
FRANTIC	; FRANTIC CUBE

	CLRALL
	MSET
	VOX 1,1,1
	VOX 1,2,1
	VOX 2,1,1
	VOX 2,2,1
	VOX 1,1,2
	VOX 1,2,2
	VOX 2,1,2
	VOX 2,2,2
	SHOW
	
	LDR RHOLD, 11
	LDR R0, 25	

	LDR R0,1
	LDR R1,1
	LDR R2,1
	LDTMR .5
	ADDTRND .10
	
MOVEX
	
	LDRAND R3,5
	SKIPNZ
	JUMP LEFT
	DECRSZ R3
	JUMP RIGHT
	
MOVEY
	LDRAND R3,4
	SKIPNZ
	JUMP DOWN
	DECRSZ R3
	JUMP UP

MOVEZ
	LDRAND R3,3
	SKIPNZ
	JUMP OUT
	DECRSZ R3
	JUMP IN
DONEZ	
	SHOW
	SKIPTOUT
	JUMP MOVEX
	
	RET
	

LEFT	CMP R0,0
	SKIPNZ 
	JUMP MOVEY
	SHXL
	DECR R0 
	JUMP MOVEY
	
RIGHT	CMP R0,3
	SKIPNZ 
	JUMP MOVEY
	SHXR
	INCR R0 
	JUMP MOVEY
	;==========
	
	
DOWN	CMP R1,0
	SKIPNZ 
	JUMP MOVEZ
	SHYD
	DECR R1 
	JUMP MOVEZ
	
UP	CMP R1,3
	SKIPNZ 
	JUMP MOVEZ
	SHYU
	INCR R1 
	JUMP MOVEZ
	;==========
	
	
	
IN	CMP R2,0
	SKIPNZ 
	JUMP DONEZ
	SHZF
	DECR R2
	JUMP DONEZ
	
OUT	CMP R2,3
	SKIPNZ 
	JUMP DONEZ
	SHZB
	INCR R2 
	JUMP DONEZ

;-------------------------------------------------------
; SPINNER


SPINNER
	CLRALL
	MSET
	LDR RHOLD, 12
	LDTMR 10
	ADDTRND 6

SPINNER.LOOP
	SHZB
	;SHZB
	LDXYZ 0,2,0
	LINEX
	MCLR
	VOX 2,2,0
	MSET
	SHOW
	
	SHZB
	;SHZB
	LDXYZ 0,0,0
	LINE 1,1,0,5
	MCLR
	VOX 2,2,0
	MSET
	SHOW

	SHZB
	;SHZB
	LDXYZ 2,0,0
	LINEY
	MCLR
	VOX 2,2,0
	MSET
	SHOW
	
	SHZB
	;SHZB
	LDXYZ 0,4,0
	LINE 1,-1,0,5
	MCLR
	VOX 2,2,0
	MSET
	SHOW


	
	SKIPTOUT
	JUMP SPINNER.LOOP
	RET

;-----------------------------------------------
;BOXIT
BOXIT
	MSET
	CLRALL
	LDR RHOLD,15


	LDXYZ 4,0,0
	LINEX
	SHOW
	LINEZ
	SHOW
	LDXYZ 0,0,4
	LINEX
	SHOW
	LINEZ
	SHOW

	VOX 0,1,0
	VOX 0,1,4
	VOX 4,1,0
	VOX 4,1,4
	SHOW
	
	VOX 0,2,0
	VOX 0,2,4
	VOX 4,2,0
	VOX 4,2,4
	SHOW

	VOX 0,3,0
	VOX 0,3,4
	VOX 4,3,0
	VOX 4,3,4
	SHOW

	LDXYZ 4,4,0
	LINEX
	SHOW
	LINEZ
	SHOW
	LDXYZ 0,4,4
	LINEX
	SHOW
	LINEZ
	LDR RHOLD, 50
	SHOW
	LDR RHOLD, 15

	PLANEZ
	SHOW
	SHZF
	SHOW
	SHZF
	SHOW
	SHZF
	SHOW
	SHZF
	LDR RHOLD, 50
	SHOW
	RET
	

;--------------------------------------------------------
; CUBE FILL TOP-RIGHT TO BOTTOM-LEFT	
CUBEFILL_TR	LDR RHOLD,15
	MSET
	CLRALL
	VOX 4,4,4
	SHOW

	MCLR	
	SETALL
	VOX 0,0,0
	JSR PLANEXYZ
	VOX 1,1,1	
	JSR PLANEXYZ
	VOX 2,2,2
	SHOW

	SETALL
	VOX 0,0,0
	JSR PLANEXYZ
	VOX 1,1,1	
	JSR PLANEXYZ
	SHOW

	SETALL
	VOX 0,0,0
	JSR PLANEXYZ
	SHOW
	
	SETALL
	SHOW
	MSET
	RET

;-------------------------------------------------------------
; CUBE FILL  BOTTOM-LEFT TO TOP-RIGHT
CUBEFILL_BL	LDR RHOLD,15
	MSET
	CLRALL
	VOX 0,0,0
	SHOW

	MCLR	
	SETALL
	VOX 4,4,4
	JSR PLANEXYZ
	VOX 3,3,3	
	JSR PLANEXYZ
	VOX 2,2,2
	SHOW

	SETALL
	VOX 4,4,4
	JSR PLANEXYZ
	VOX 3,3,3	
	JSR PLANEXYZ
	SHOW

	SETALL
	VOX 4,4,4
	JSR PLANEXYZ
	SHOW
	
	SETALL
	SHOW
	MSET
	RET



PLANEXYZ	PLANEX
	PLANEY
	PLANEZ
	RET
	
;------------------------------------------
; THING

THING	CLRALL
	LDR RHOLD,9
	MSET
	VOX 2,2,4
	SHOW

	VOX 2,2,3
	VOX 1,2,3
	VOX 3,2,3
	VOX 2,1,3
	VOX 2,3,3
	SHOW

	LDXYZ 2,2,2
	LINEX
	LINEY
	VOX 1,3,2
	VOX 1,1,2
	VOX 3,3,2
	VOX 3,1,2
	SHOW

	SHZF
	VOX 2,2,4
	SHOW
	SHZF
	VOX 2,2,4
	SHOW

	SHZF
	VOX 2,2,4
	LDXYZ 0,0,0
	PLANEZ
	MCLR
	VOX 0,0,0
	VOX 0,4,0
	VOX 4,0,0
	VOX 4,4,0
	SHOW

	MSET
	SHZF
	VOX 2,2,4
	LDXYZ 0,0,0
	PLANEZ
	SHOW

	MCLR
	VOX 2,2,4
	VOX 2,2,0
	SHOW

	VOX 2,2,3

	VOX 2,2,0
	VOX 1,2,0
	VOX 3,2,0
	VOX 2,1,0
	VOX 2,3,0
	SHOW
	

	VOX 2,2,2
	LDXYZ 2,2,0
	LINEX
	LINEY
	VOX 1,3,0
	VOX 1,1,0
	VOX 3,3,0
	VOX 3,1,0
	SHOW

	MSET
	CLRALL
	VOX 0,0,0
	VOX 0,4,0
	VOX 4,0,0
	VOX 4,4,0
	SHOW
	SHZB
	SHOW
	SHZB
	SHOW
	SHZB
	SHOW
	SHZB
	SHOW

	CLRALL
	VOX 1,1,4
	VOX 1,3,4
	VOX 3,1,4
	VOX 3,3,4
	SHOW
	CLRALL	
	VOX 2,2,4
	SHOW

	RET

;------------------------------------------------
; DIAGONAL THING
DGTHING
	CLRALL
	MSET
	LDR RHOLD,14

	LDXYZ 0,0,0

	JSR PLANEXYZ
	SHOW
	CLRALL
	LDXYZ 1,1,1
	JSR PLANEXYZ
	SHOW
	CLRALL
	LDXYZ 2,2,2
	JSR PLANEXYZ
	SHOW
	CLRALL
	LDXYZ 3,3,3
	JSR PLANEXYZ
	SHOW
	CLRALL
	LDXYZ 4,4,4	
	JSR PLANEXYZ
	SHOW
	RET


	LDR R0,5
LOOP_1	
	SHZF
	SHXL
	SHYD
	VOX 4,4,4
	SHOW
	DECRSZ R0
	JUMP LOOP_1
	RET

;---------------------------------------------
; WAVES (IN X,Y AND Z AXIS)

WAVEX	JSR    WAVE.setup
	JUMP   WAVEX.loop

WAVEY	JSR    WAVE.setup
	JUMP   WAVEY.loop

WAVEZ	JSR    WAVE.setup
	JUMP   WAVEZ.loop


WAVE.setup	CLRALL
	MSET
	LDRAND  RHOLD,8
	PUSHR RHOLD
	LDR RHOLD,8
	PUSHR RHOLD
	ADD
	PULLR RHOLD
	LDXYZ 0,2,0
	LDR R0,1
	LDTMR 4
	ADDTRND 6
	RET	


WAVEX.loop	
	LINEZ
	SHOW
	SHXR

	PUSHR R0
	PUSHR RY
	ADD
	PULLR RY
	CMP RY,4
	SKIPNZ
	LDR R0,-1
	CMP RY,0
	SKIPNZ
	LDR R0,1
	SKIPTOUT
	JUMP WAVEX.loop
	RET

WAVEZ.loop	
	LINEY
	SHOW
	SHZB

	PUSHR R0
	PUSHR RX
	ADD
	PULLR RX
	CMP RX,4
	SKIPNZ
	LDR R0,-1
	CMP RX,0
	SKIPNZ
	LDR R0,1
	SKIPTOUT
	JUMP WAVEZ.loop
	RET


WAVEY.loop	
	LINEX
	SHOW
	SHZB

	PUSHR R0
	PUSHR RY
	ADD
	PULLR RY
	CMP RY,4
	SKIPNZ
	LDR R0,-1
	CMP RY,0
	SKIPNZ
	LDR R0,1
	SKIPTOUT
	JUMP WAVEY.loop
	RET
; END OF WAVES
;-----------------------------------------------
; STRIP LAYERS
STRIP.LAYERS
	LDR RHOLD, 7
	PUSHR RHOLD
	LDRAND RHOLD, 10
	PUSHR RHOLD
	ADD
	PULLR RHOLD


	SETALL
	SHOW
	MCLR
	
	LDXYZ 0,4,0
	JSR STRIP.outer
	JSR STRIP.outer
	JSR STRIP.outer
	JSR STRIP.outer
	JSR STRIP.outer
	SHOW
	SHOW

	LDXYZ 1,4,1
	JSR STRIP.inner
	JSR STRIP.inner
	JSR STRIP.inner
	JSR STRIP.inner
	JSR STRIP.inner
	SHOW
	SHOW
	
	VOX 2,4,2
	SHOW
	VOX 2,3,2
	SHOW
	VOX 2,2,2
	SHOW
	VOX 2,1,2
	SHOW
	VOX 2,0,2
	SHOW
	SHOW
	RET
	


STRIP.outer
	LINE 1,0,0,5
	LINE 0,0,1,5
	LINE -1,0,0,5
	LINE 0,0,-1,5
	SHOW
	DECY
	RET

STRIP.inner
	LINE 1,0,0,3
	LINE 0,0,1,3
	LINE -1,0,0,3
	LINE 0,0,-1,3
	SHOW
	DECY
	RET


;----------------------------------
; Bounce the plane

BOUNCE.IT	LDR RHOLD,10
	CLRALL
	SHOW

	LDTMR	3
	ADDTRND	4

	MSET
	VOX 4,4,4
	LDRAND R3,3
	LDR RHOLD,10
	JSR	PLANE.INIT

	LDR	RHOLD,5
	PUSHR 	RHOLD
	LDRAND	RHOLD,12
	PUSHR	RHOLD
	ADD
	PULLR	RHOLD
	

BOUNCE.IT.LOOP
	JSR	PLANE
	SKIPTOUT
	JUMP	BOUNCE.IT.LOOP
	RET


	

;-----------------------------------
; Fill and wipe
FILLnWIPE
	LDR RHOLD,25
	SETALL
	SHOW
	MSET
	VOX 4,4,4
	LDRAND R3,4
	LDR RHOLD,10
	JSR PLANE
	RET

;-----------------------------------
; Set R3 to 0,1 or 2
; call PLANE.INIT once
;
PLANE.INIT	CMP R3,0
	SKIPNZ
	PLANEZ
	CMP R3,1
	SKIPNZ
	PLANEY
	CMP R3,2
	SKIPNZ
	PLANEX
	RET

;--------------------------------------
; With R3 set and PLANE.INIT called 
; call PLANE to run one complete sweep

PLANE	JSR PLANE.ONE
	JSR PLANE.ONE
	JSR PLANE.ONE
	JSR PLANE.ONE

	JSR PLANE.TWO
	JSR PLANE.TWO
	JSR PLANE.TWO
	JSR PLANE.TWO
	RET


PLANE.ONE	CMP R3,0
	SKIPNZ
	SHZF
	CMP R3,1
	SKIPNZ
	SHYD
	CMP R3,2
	SKIPNZ
	SHXL
	SHOW
	RET

PLANE.TWO	CMP R3,0
	SKIPNZ
	SHZB
	CMP R3,1
	SKIPNZ
	SHYU
	CMP R3,2
	SKIPNZ
	SHXR
	SHOW
	RET

;------------------------------------
; FRONT-BACK-FRONT LINE WIGGLE


WIGGLE	LDR	R0,1
	PUSHR	R0
	LDRAND	R0,4
	PUSHR	R0
	ADD	
	PULLR	R0


	CLRALL
	MSET
	LDR	RHOLD,3
	PUSHR	RHOLD
	LDRAND	RHOLD,7
	PUSHR	RHOLD
	ADD
	PULLR	RHOLD
	LDXYZ	0,0,0
	LINEX
	JSR WIGGLE.UP
WIGGLE.LP	SHZB
	JSR WIGGLE.DN
	SHZB
	JSR WIGGLE.UP
	SHZB
	JSR WIGGLE.DN
	SHZB
	JSR WIGGLE.UP

	SHZF
	JSR WIGGLE.DN
	SHZF
	JSR WIGGLE.UP
	SHZF
	JSR WIGGLE.DN
	SHZF
	JSR WIGGLE.UP


	DECRSZ	R0
	JUMP WIGGLE.LP

	RET


WIGGLE.UP	SHOW
	SHYU
	SHOW
	SHYU
	SHOW
	SHYU
	SHOW
	SHYU
	SHOW
	RET

WIGGLE.DN	SHOW
	SHYD	
	SHOW
	SHYD	
	SHOW
	SHYD	
	SHOW
	SHYD
	SHOW
	RET	
;------------------------------------
; XLINE


XLINE	LDR	R0,3
	PUSHR	R0
	LDRAND	R0,6
	PUSHR	R0
	ADD	
	PULLR	R0


	CLRALL
	MSET
	LDR	RHOLD,3
	PUSHR	RHOLD
	LDRAND	RHOLD,8
	PUSHR	RHOLD
	ADD
	PULLR	RHOLD
	LDXYZ	0,0,0



	LDXYZ	0,0,0
	LINEZ
	LDXYZ	4,0,0
	LINEZ
	SHOW
XLINE.LP	CLRALL

	LDXYZ	1,1,0
	LINEZ
	LDXYZ	3,1,0
	LINEZ
	SHOW
	CLRALL

	LDXYZ	2,2,0
	LINEZ
	SHOW
	CLRALL

	LDXYZ	1,3,0
	LINEZ
	LDXYZ	3,3,0
	LINEZ
	SHOW
	CLRALL

	LDXYZ	0,4,0
	LINEZ
	LDXYZ	4,4,0
	LINEZ
	SHOW

	SHYD
	SHOW
	SHYD
	SHOW
	SHYD
	SHOW
	SHYD
	SHOW


	DECRSZ	R0
	JUMP XLINE.LP

	RET

	RANDSEED	



;-------------------------------
;
THEFLY
	MSET
	LDR RHOLD,2
	LDR	R0,1
	LDR	R1,1
	LDR	R2,1
	LDXYZ	2,2,2
	LDTMR 5
	ADDTRND 10	

FLY.LOOP	CLRALL
	VOXM
	SHOW
	JSR	FLY.UPDATE
	SKIPTOUT
	JUMP	FLY.LOOP	
	RET
	
	
FLY.UPDATE
	PUSHR	R0
	PUSHR	RX
	ADD
	PULLR	RX

	PUSHR	R1
	PUSHR	RY
	ADD
	PULLR	RY

	PUSHR	R2
	PUSHR	RZ
	ADD
	PULLR	RZ
	
	CMP	RX,0
	SKIPNZ
	JSR	FLY.DIR.PLUX
	CMP	RX,4
	SKIPNZ
	JSR	FLY.DIR.NEGX
	
	CMP	RY,0
	SKIPNZ
	JSR	FLY.DIR.PLUY
	CMP	RY,4
	SKIPNZ
	JSR	FLY.DIR.NEGY	

	CMP	RZ,0
	SKIPNZ
	JSR	FLY.DIR.PLUZ
	CMP	RZ,4
	SKIPNZ
	JSR	FLY.DIR.NEGZ

	RET
	
	
FLY.DIR.PLUX	JSR	FLY.DIR.PLUS
	PULLR	R0
	RET
FLY.DIR.NEGX	JSR	FLY.DIR.MINUS
	PULLR	R0
	RET

FLY.DIR.PLUY	JSR	FLY.DIR.PLUS
	PULLR	R1
	RET
FLY.DIR.NEGY	JSR	FLY.DIR.MINUS
	PULLR	R1
	RET

FLY.DIR.PLUZ	JSR	FLY.DIR.PLUS
	PULLR	R2
	RET
FLY.DIR.NEGZ	JSR	FLY.DIR.MINUS
	PULLR	R2
	RET
		
	
FLY.DIR.PLUS	JSR	FLY.DELAY
	LDRAND	R3,2
	PUSHR	R3
	
	RET


FLY.DIR.MINUS	JSR	FLY.DELAY
	LDRAND	R3,2
	CMP	R3,1
	SKIPNZ
	LDR	R3,-1
	PUSHR 	R3
	RET
	
FLY.DELAY	LDR	RHOLD,1
	PUSHR	RHOLD
	LDRAND	RHOLD,8
	PUSHR	RHOLD
	ADD
	PULLR	RHOLD
	RET

;-----------------------------------------------
; JAN-2011
SPEEDY.DOT
	CLRALL
	
	LDR	RHOLD,2
	PUSHR	RHOLD
	LDRAND	RHOLD,6
	PUSHR	RHOLD
	ADD
	PULLR	RHOLD


	LDXYZ 0,0,0

	JSR SPEEDY.DOT.XINC
	INCY
	JSR SPEEDY.DOT.XDEC
	INCY
	JSR SPEEDY.DOT.XINC
	INCY
	JSR SPEEDY.DOT.XDEC
	INCY
	JSR SPEEDY.DOT.XINC

	INCZ
	JSR SPEEDY.DOT.XDEC
	INCZ
	JSR SPEEDY.DOT.XINC
	INCZ
	JSR SPEEDY.DOT.XDEC
	INCZ
	JSR SPEEDY.DOT.XINC

	DECY
	JSR SPEEDY.DOT.XDEC
	DECY
	JSR SPEEDY.DOT.XINC
	DECY
	JSR SPEEDY.DOT.XDEC
	DECY
	JSR SPEEDY.DOT.XINC

	DECZ
	JSR SPEEDY.DOT.XDEC
	DECZ
	JSR SPEEDY.DOT.XINC
	DECZ
	JSR SPEEDY.DOT.XDEC
	DECZ
	JSR SPEEDY.DOT.XINC

	RET


SPEEDY.DOT.XINC
	MSET
	VOXM
	SHOW

	MCLR
	VOXM
	INCX	
	SKIPZ
	JUMP SPEEDY.DOT.XINC
	MCLR
	DECX
	RET	

SPEEDY.DOT.XDEC
	MSET
	VOXM
	SHOW
	MCLR
	VOXM
	DECX
	CMP RX,4	
	SKIPZ
	JUMP SPEEDY.DOT.XDEC
	INCX
	RET	





;-----------------------------------------------
; JAN-2011
CUBE_DISSOLVE
	LDR RHOLD,40
	CLRALL
	MSET
	LDR RY,0
	PLANEY
	SHOW

	LDR RZ,4
	PLANEZ
	SHOW

	LDR RY,4
	PLANEY
	SHOW

	LDR RX,0
	PLANEX
	SHOW

	LDR RX,4
	PLANEX
	SHOW

	LDR RZ,0
	PLANEZ
	SHOW

	MCLR
	LDR R0,255
	LDR RHOLD,0
		
CUBEDIZ_LP	JSR CUBEDIZ_RNDREM
	VOXM
	SHOW
	DECRSZ R0
	JUMP   CUBEDIZ_LP

	RET
	
CUBEDIZ_RNDREM
	LDRAND R1,3
	DECR R1
	SKIPNZ
	JUMP CUBEDIZ_XZ
	DECR R1
	SKIPNZ
	JUMP CUBEDIZ_ZY


CUBEDIZ_XY	LDR RZ,0
	LDRAND R1,2
	DECRSZ R1
	LDR RZ,4

	LDRAND RX,5
	LDRAND RY,5
	RET

CUBEDIZ_XZ	LDR RY,0
	LDRAND R1,2
	DECRSZ R1
	LDR RY,4

	LDRAND RX,5
	LDRAND RZ,5
	RET

CUBEDIZ_ZY	LDR RX,0
	LDRAND R1,2
	DECRSZ R1
	LDR RX,4

	LDRAND RZ,5
	LDRAND RY,5
	RET

;-----------------------------------------------
; JAN-2011
ARROW_HEAD
	LDR RHOLD,10
	MSET
	VOX 2,2,4
	SHOW

	SHZF
	VOX 2,1,4
	VOX 1,2,4
	VOX 2,2,4
	VOX 2,3,4
	VOX 3,2,4
	SHOW

	SHZF
	VOX 2,4,4
	VOX 4,2,4
	VOX 2,2,4
	VOX 2,0,4
	VOX 0,2,4
	SHOW

	SHZF
	SHOW
	VOX 2,2,4

	SHZF
	SHOW
	VOX 2,2,4

	SHZF
	SHOW
	VOX 2,2,4
	
	SHZF
	SHOW
	SHZF
	SHOW
	SHZF
	SHOW
	SHZF
	SHOW
	SHZF
	SHOW
	RET
;------------------------------------------------
; JAN-2011

COUNTDOWN
	CLRALL
	LDR RZ,4
	MSET
	LDR R0, '5'
	JSR WRITE
	LDR R0, '4'
	JSR WRITE
	LDR R0, '3'
	JSR WRITE
	LDR R0, '2'
	JSR WRITE
	LDR R0, '1'
	JSR WRITE

	CLRALL
	MSET

	LDR RHOLD,25
	MSET
	VOX 2,0,2
	SHOW

	LDR RHOLD,21
	SHYU
	VOX 2,0,1
	VOX 1,0,2
	VOX 2,0,2
	VOX 2,0,3
	VOX 3,0,2
	SHOW

	LDR RHOLD,17
	SHYU
	VOX 2,0,4
	VOX 4,0,2
	VOX 2,0,2
	VOX 2,0,0
	VOX 0,0,2
	SHOW

	LDR RHOLD,14
	SHYU
	VOX 2,0,1
	VOX 1,0,2
	VOX 2,0,2
	VOX 2,0,3
	VOX 3,0,2
	SHOW
	VOX 2,0,2

	LDR RHOLD,10
	SHYU
	VOX 2,0,1
	VOX 1,0,2
	VOX 2,0,2
	VOX 2,0,3
	VOX 3,0,2
	SHOW
	VOX 2,0,2

	LDR RHOLD,9
	SHYU
	VOX 2,0,1
	VOX 1,0,2
	VOX 2,0,2
	VOX 2,0,3
	VOX 3,0,2
	SHOW
	VOX 2,0,2
	SHOW	
	LDR RHOLD,8

	SHYU
	VOX 2,0,2
	SHOW
	SHYU
	VOX 2,0,2
	SHOW
	LDR RHOLD,6
	SHYU
	SHOW
	SHYU
	SHOW
	SHYU
	SHOW
	SHYU
	SHOW
	RET


;-------------------------------------------------------
; SPIRAL - JAN-2011


SPIRAL
	CLRALL
	MSET
	LDR RHOLD, 12
	LDTMR 10
	ADDTRND 6

SPIRAL.LOOP
	SHYU
	LDXYZ 2,0,2
	LINE 1,0,0,3
	SHOW
	
	SHYU
	LDXYZ 2,0,2
	LINE 1,0,1,3
	SHOW

	SHYU
	LDXYZ 2,0,2
	LINE 0,0,1,3
	SHOW

	SHYU
	LDXYZ 2,0,2
	LINE -1,0,1,3
	SHOW

	SHYU
	LDXYZ 2,0,2
	LINE -1,0,0,3
	SHOW

	SHYU
	LDXYZ 2,0,2
	LINE -1,0,-1,3
	SHOW

	SHYU
	LDXYZ 2,0,2
	LINE 0,0,-1,3
	SHOW
	
	SKIPTOUT
	JUMP SPIRAL.LOOP
	RET

;----------------------------------------------------------
; start of 8K extra animations

;------------------------------------

SPRAY
    LDR RHOLD,11
    LDTMR 14
	LDR RY,0
	CLRALL
	MSET
	LDR R0,0
	JSR INIT_SHOOT
SHOOT_LOOP
	JSR RND_MOVE
	VOXM
	SHOW
	SHYU
	SKIPTOUT
	JUMP SHOOT_LOOP
	RET

RND_MOVE
	LDRAND R1, 16
	CMP R1,0
	SKIPNZ
	JSR MINCX
	CMP R1,1
	SKIPNZ
	JSR MINCZ
	CMP R1,2
	SKIPNZ
	JSR MDECX
	CMP R1,3
	SKIPNZ
	JSR MDECZ
	CMP R1,4
	SKIPNZ
	JSR MINCZ
	CMP R1,5
	SKIPNZ
	JSR MINCX
	CMP R1,6
	SKIPNZ
	JSR MDECX
	CMP R1,7
	SKIPNZ
	JSR MDECZ
	CMP R1,8
	SKIPNZ
	JSR MINCXZ
	CMP R1,9
	SKIPNZ
	JSR MINCXDECZ
	CMP R1,10
	SKIPNZ
	JSR MDECXZ
	CMP R1,11
	SKIPNZ
	JSR MDECXINCZ
	CMP R1,12
	SKIPNZ
	JSR MINCXZ
	CMP R1,13
	SKIPNZ
	JSR MINCXDECZ
	CMP R1,14
	SKIPNZ
	JSR MDECXZ
	CMP R1,15
	SKIPNZ
	JSR MDECXINCZ
	RET

INIT_SHOOT
	LDRAND RX,3
	INCR RX
	LDRAND RZ,3
	INCR RZ
    VOXM
	SHOW
    RET

MINCX
	CMP RX,4
	SKIPZ
	INCX
	RET

MINCZ
	CMP RZ,4
	SKIPZ
	INCZ
	RET

MDECX
	CMP RX,0
	SKIPZ
	DECX
	RET

MDECZ
	CMP RZ,0
	SKIPZ
	DECZ
	RET

MINCXZ
	CMP RZ,4
	SKIPZ
	INCZ
	CMP RX,4
	SKIPZ
	INCX
	RET

MINCXDECZ
	CMP RX,4
	SKIPZ
	INCX
	CMP RZ,0
	SKIPZ
	DECZ
	RET

MDECXZ
	CMP RX,0
	SKIPZ
	DECX
	CMP RZ,0
	SKIPZ
	DECZ
	RET

MDECXINCZ
	CMP RX,0
	SKIPZ
	DECX
	CMP RZ,4
	SKIPZ
	INCZ
	RET
;-------------------------------------------------------------------
SLOWSHOW	LDR	RHOLD,9
	MSET
	JSR SS_LOOP
	JSR SS_LOOP2
	JSR HIDEOUT
	RET

SS_LOOP	CLRALL
	INCR RHOLD
	VOX 4,0,0
	VOX 0,0,4
	SHOW
	VOX 3,0,0
	VOX 0,0,3
	VOX 4,0,1
	VOX 1,0,4
	SHOW
	VOX 2,0,0
	VOX 0,0,2
	VOX 2,0,4
	VOX 4,0,2
	SHOW
	VOX 1,0,0
	VOX 0,0,1
	VOX 3,0,4
	VOX 4,0,3
	SHOW
	VOX 0,0,0
	VOX 4,0,4
	SHOW
	VOX 0,1,0
	VOX 4,1,4
	SHOW
	VOX 0,2,0
	VOX 4,2,4
	SHOW
	VOX 0,3,0
	VOX 4,3,4
	SHOW
	VOX 0,4,0
	VOX 4,4,4
	SHOW
	VOX 1,4,0
	VOX 0,4,1
	VOX 4,4,3
	VOX 3,4,4
	SHOW
	VOX 2,4,0
	VOX 0,4,2
	VOX 2,4,4
	VOX 4,4,2
	SHOW
	VOX 3,4,0
	VOX 0,4,3
	VOX 4,4,1
	VOX 1,4,4
	SHOW
	VOX 4,4,0
	VOX 0,4,4
	SHOW
	VOX 4,3,0
	VOX 0,3,4
	SHOW
	VOX 4,2,0
	VOX 0,2,4
	SHOW
	VOX 4,1,0
	VOX 0,1,4
	INCR RHOLD
	INCR RHOLD
	INCR RHOLD
	SHOW
	RET

SS_LOOP2
	VOX 1,0,1
	VOX 3,0,3
	SHOW
	VOX 2,0,1
	VOX 1,0,2
	VOX 3,0,2
	VOX 2,0,3
	SHOW
	VOX 3,0,1
	VOX 1,0,3
	SHOW
	VOX 3,1,1
	VOX 1,1,3
	SHOW
	VOX 3,2,1
	VOX 1,2,3
	SHOW
	VOX 3,3,1
	VOX 1,3,3
	SHOW
	VOX 3,4,1
	VOX 1,4,3
	SHOW
	VOX 2,4,1
	VOX 1,4,2
	VOX 2,4,3
	VOX 3,4,2
	SHOW
	VOX 1,4,1
	VOX 3,4,3
	SHOW
	VOX 1,3,1
	VOX 3,3,3
	SHOW
	VOX 1,2,1
	VOX 3,2,3
	SHOW
	VOX 1,1,1
	VOX 3,1,3
	SHOW
	VOX 2,0,2
	SHOW
	VOX 2,1,2
	SHOW
	VOX 2,2,2
	SHOW
	VOX 2,3,2
	SHOW
	VOX 2,4,2
	SHOW
	RET

HIDE
	MCLR
	VOXM
	DECY
	MSET
	VOXM
	SHOW
	DECRSZ R0
	JUMP HIDE
	MCLR
	SHOW
	RET

HIDE1 LDR R0,4
	INCR RHOLD
	JSR HIDE
	RET

HIDEOUT	LDR RHOLD, 1
	VOX 2,4,2
	JSR HIDE1
	VOX 1,4,2
	JSR HIDE1
	VOX 1,4,3
	JSR HIDE1
	VOX 2,4,3
	JSR HIDE1
	VOX 3,4,3
	JSR HIDE1
	LDR RHOLD, 1
	VOX 3,4,2
	JSR HIDE1
	VOX 3,4,1
	JSR HIDE1
	VOX 2,4,1
	JSR HIDE1
	VOX 1,4,1
	JSR HIDE1
	VOX 0,4,1
	JSR HIDE1
	LDR RHOLD, 1
	VOX 0,4,2
	JSR HIDE1
	VOX 0,4,3
	JSR HIDE1
	VOX 0,4,4
	JSR HIDE1
	VOX 1,4,4
	JSR HIDE1
	VOX 2,4,4
	JSR HIDE1
	LDR RHOLD,1
	VOX 3,4,4
	JSR HIDE1
	VOX 4,4,4
	JSR HIDE1
	VOX 4,4,3
	JSR HIDE1
	VOX 4,4,2
	JSR HIDE1
	VOX 4,4,1
	JSR HIDE1
	LDR RHOLD, 1
	VOX 4,4,0
	JSR HIDE1
	VOX 3,4,0
	JSR HIDE1
	VOX 2,4,0
	JSR HIDE1
	VOX 1,4,0
	JSR HIDE1
	VOX 0,4,0
	JSR HIDE1
	LDR RHOLD, 20
	SHYU
	SHOW
	SHYU
	SHOW
	ROTATEX
	SHOW
	SHZB
	MSET
	LDXYZ 1,1,2
	LINE 1,0,0,3
	LINE 0,1,0,3
	LINE -1,0,0,3
	LINE 0,-1,2,3
	VOX 2,2,2
	SHOW
	SHZB
	VOX 2,2,2
	SHOW
	SHZB
	SHOW
	SHZB
	SHOW
	SHZB
	SHOW
	RET

;--------------------------
ROTAX
	MCLR
	MSET
	LDR RHOLD,9
	LDTMR 10
	ADDTRND 10
ROTAX_LOOP
	CLRALL
	MSET
FIGURE1
	CLRALL
	MSET
	LDXYZ 2,4,0				;|
	LINE 0,0,1,5
	;---------
	LDXYZ 2,3,1				;,|
	LINE 0,0,1,3
	VOX 1,3,0
	VOX 3,3,4
	;---------
	LDXYZ 0,2,0				;/
	LINE 1,0,1,5
	;---------
	LDXYZ 1,1,1				;,-
	LINE 1,0,1,3
	VOX 4,1,3
	VOX 0,1,1
	;---------
	LDXYZ 0,0,2				;--
	LINE 1,0,0,5
	;---------
	SHOW
	JSR DELETE

FIGURE2
	CLRALL
	MSET
	LDXYZ 2,4,1				;,|
	LINE 0,0,1,3
	VOX 1,4,0
	VOX 3,4,4
	;---------
	LDXYZ 0,3,0				;/
	LINE 1,0,1,5
	;---------
	LDXYZ 1,2,1				;,-
	LINE 1,0,1,3
	VOX 4,2,3
	VOX 0,2,1
	;---------
	LDXYZ 0,1,2				;--
	LINE 1,0,0,5
	;---------
	LDXYZ 3,0,1				;\,
	LINE -1,0,1,3
	VOX 3,0,0
	VOX 1,0,4
	;---------
	SHOW
	JSR DELETE

FIGURE3
	CLRALL
	MSET
	LDXYZ 0,4,0				;/
	LINE 1,0,1,5
	;---------
	LDXYZ 1,3,1				;,-
	LINE 1,0,1,3
	VOX 4,3,3
	VOX 0,3,1
	;---------
	LDXYZ 0,2,2				;--
	LINE 1,0,0,5
	;---------
	LDXYZ 3,1,1				;\,
	LINE -1,0,1,3
	VOX 3,1,0
	VOX 1,1,4
	;---------
	LDXYZ 4,0,0				;\
	LINE -1,0,1,5
	;---------
	SHOW
	JSR DELETE

FIGURE4
	CLRALL
	MSET
	LDXYZ 1,4,1				;,-
	LINE 1,0,1,3
	VOX 4,4,3
	VOX 0,4,1
	;---------
	LDXYZ 0,3,2				;--
	LINE 1,0,0,5
	;---------
	LDXYZ 3,2,1				;\,
	LINE -1,0,1,3
	VOX 3,2,0
	VOX 1,2,4
	;---------
	LDXYZ 4,1,0				;\
	LINE -1,0,1,5
	;---------
	LDXYZ 3,0,1				;\,
	LINE -1,0,1,3
	VOX 3,0,0
	VOX 1,0,4
	;---------
	SHOW
	JSR DELETE

FIGURE5
	LDXYZ 0,4,2				;--
	LINE 1,0,0,5
	;---------
	LDXYZ 1,3,2				;--,
	LINE 1,0,0,3
	VOX 4,3,1
	VOX 0,3,3
	;---------
	LDXYZ 4,2,0				;\
	LINE -1,0,1,5
	;---------
	LDXYZ 3,1,1				;\,
	LINE -1,0,1,3
	VOX 3,1,0
	VOX 1,1,4
	;---------
	LDXYZ 2,0,0				;|
	LINE 0,0,1,5
	;---------
	SHOW
	JSR DELETE

FIGURE6
	LDXYZ 1,4,2				;--,
	LINE 1,0,0,3
	VOX 4,4,1
	VOX 0,4,3
	;---------
	LDXYZ 4,3,0				;\
	LINE -1,0,1,5
	;---------
	LDXYZ 3,2,1				;\,
	LINE -1,0,1,3
	VOX 3,2,0
	VOX 1,2,4
	;---------
	LDXYZ 2,1,0				;|
	LINE 0,0,1,5
	;---------
	LDXYZ 2,0,1				;,|
	LINE 0,0,1,3
	VOX 1,0,0
	VOX 3,0,4
	;---------
	SHOW
	JSR DELETE

FIGURE7
	LDXYZ 4,4,0				;\
	LINE -1,0,1,5
	;---------
	LDXYZ 3,3,1				;\,
	LINE -1,0,1,3
	VOX 3,3,0
	VOX 1,3,4
	;---------
	LDXYZ 2,2,0				;|
	LINE 0,0,1,5
	;---------
	LDXYZ 2,1,1				;,|
	LINE 0,0,1,3
	VOX 1,1,0
	VOX 3,1,4
	;---------
	LDXYZ 0,0,0				;/
	LINE 1,0,1,5
	;---------
	SHOW
	JSR DELETE

FIGURE8
	LDXYZ 3,4,1				;\,
	LINE -1,0,1,3
	VOX 3,4,0
	VOX 1,4,4
	;---------
	LDXYZ 2,3,0				;|
	LINE 0,0,1,5
	;---------
	LDXYZ 2,2,1				;,|
	LINE 0,0,1,3
	VOX 1,2,0
	VOX 3,2,4
	;---------
	LDXYZ 0,1,0				;/
	LINE 1,0,1,5
	;---------
	LDXYZ 1,0,1				;,-
	LINE 1,0,1,3
	VOX 4,0,3
	VOX 0,0,1
	;---------
	SHOW
	JSR DELETE

FIGURE9
	LDXYZ 2,4,0				;|
	LINE 0,0,1,5
	;---------
	LDXYZ 2,3,1				;,|
	LINE 0,0,1,3
	VOX 1,3,0
	VOX 3,3,4
	;---------
	LDXYZ 0,2,0				;/
	LINE 1,0,1,5
	;---------
	LDXYZ 1,1,1				;,-
	LINE 1,0,1,3
	VOX 4,1,3
	VOX 0,1,1
	;---------
	LDXYZ 0,0,2				;--
	LINE 1,0,0,5
	;---------
	SHOW
	JSR DELETE

FIGURE10
	LDXYZ 2,4,1				;,|
	LINE 0,0,1,3
	VOX 1,4,0
	VOX 3,4,4
	;---------
	LDXYZ 0,3,0				;/
	LINE 1,0,1,5
	;---------
	LDXYZ 1,2,1				;,-
	LINE 1,0,1,3
	VOX 4,2,3
	VOX 0,2,1
	;---------
	LDXYZ 0,1,2				;--
	LINE 1,0,0,5
	;---------
	LDXYZ 1,0,2				;--,
	LINE 1,0,0,3
	VOX 0,0,3
	VOX 4,0,1
	;---------
	SHOW
	JSR DELETE

FIGURE11
	LDXYZ 0,4,0				;/
	LINE 1,0,1,5
	;---------
	LDXYZ 1,3,1				;,-
	LINE 1,0,1,3
	VOX 4,3,3
	VOX 0,3,1
	;---------
	LDXYZ 0,2,2				;--
	LINE 1,0,0,5
	;---------
	LDXYZ 1,1,2				;--,
	LINE 1,0,0,3
	VOX 0,1,3
	VOX 4,1,1
	;---------
	LDXYZ 4,0,0				;\
	LINE -1,0,1,5
	;---------
	SHOW
	JSR DELETE

FIGURE12
	LDXYZ 1,4,1				;,-
	LINE 1,0,1,3
	VOX 4,4,3
	VOX 0,4,1
	;---------
	LDXYZ 0,3,2				;--
	LINE 1,0,0,5
	;---------
	LDXYZ 1,2,2				;--,
	LINE 1,0,0,3
	VOX 0,2,3
	VOX 4,2,1
	;---------
	LDXYZ 4,1,0				;\
	LINE -1,0,1,5
	;---------
	LDXYZ 3,0,1				;\,
	LINE -1,0,1,3
	VOX 3,0,0
	VOX 1,0,4
	;---------
	SHOW
	JSR DELETE

FIGURE13
	LDXYZ 0,4,2				;--
	LINE 1,0,0,5
	;---------
	LDXYZ 1,3,2				;--,
	LINE 1,0,0,3
	VOX 0,3,3
	VOX 4,3,1
	;---------
	LDXYZ 4,2,0				;\
	LINE -1,0,1,5
	;---------
	LDXYZ 3,1,1				;\,
	LINE -1,0,1,3
	VOX 3,1,0
	VOX 1,1,4
	;---------
	LDXYZ 2,0,0				;|
	LINE 0,0,1,5
	;---------
	SHOW
	JSR DELETE

FIGURE14
	LDXYZ 1,4,2				;--,
	LINE 1,0,0,3
	VOX 0,4,3
	VOX 4,4,1
	;---------
	LDXYZ 4,3,0				;\
	LINE -1,0,1,5
	;---------
	LDXYZ 3,2,1				;\,
	LINE -1,0,1,3
	VOX 3,2,0
	VOX 1,2,4
	;---------
	LDXYZ 2,1,0				;|
	LINE 0,0,1,5
	;---------
	LDXYZ 2,0,1				;,|
	LINE 0,0,1,3
	VOX 1,0,0
	VOX 3,0,4
	;---------
	SHOW
	JSR DELETE

FIGURE15
	LDXYZ 4,4,0				;\
	LINE -1,0,1,5
	;---------
	LDXYZ 3,3,1				;\,
	LINE -1,0,1,3
	VOX 3,4,0
	VOX 1,4,4
	;---------
	LDXYZ 2,2,0				;|
	LINE 0,0,1,5
	;---------
	LDXYZ 2,1,1				;,|
	LINE 0,0,1,3
	VOX 1,1,0
	VOX 3,1,4
	;---------
	LDXYZ 0,0,0				;/
	LINE 1,0,1,5
	;---------
	SHOW
	JSR DELETE

FIGURE16
	LDXYZ 3,4,1				;\,
	LINE -1,0,1,3
	VOX 3,4,0
	VOX 1,4,4
	;---------
	LDXYZ 2,3,0				;|
	LINE 0,0,1,5
	;---------
	LDXYZ 2,2,1				;,|
	LINE 0,0,1,3
	VOX 1,2,0
	VOX 3,2,4
	;---------
	LDXYZ 0,1,0				;/
	LINE 1,0,1,5
	;---------
	LDXYZ 1,0,1				;,-
	LINE 1,0,1,3
	VOX 4,0,3
	VOX 0,0,1
	;---------
	SHOW
	CLRALL
	MSET
	SKIPTOUT
	JUMP ROTAX_LOOP
	RET

DELETE
	CLRALL
	MSET
	RET

;----------------------------------------------------
MYHELIX
	LDTMR 6
	ADDTRND 7
	MSET

HELIX_LOOP1	CLRALL
;stage 1    /5
	LDXYZ 0,0,0
	LINE 1,1,0,5
	LINE 0,-1,1,5
	LINE -1,1,0,5
	LINE 0,-1,-1,5
	LDR RHOLD, 5
	SHOW
	CLRALL
;stage 2    /4
	LDXYZ 1,0,0
	LINE 1,1,0,4
	LDXYZ 4,4,1
	LINE 0,-1,1,4
	LDXYZ 3,0,4
	LINE -1,1,0,4
	LDXYZ 0,4,3
	LINE 0,-1,-1,4
	LDR RHOLD, 5
	SHOW
	CLRALL
;stage 3    /3
	LDXYZ 2,0,0
	LINE 1,1,0,3
	LINE 0,1,1,3
	LINE 0,-1,1,3
	LINE -1,-1,0,3
	LINE -1,1,0,3
	LINE 0,1,-1,3
	LINE 0,-1,-1,3
	LINE 1,-1,0,3
	LDR RHOLD, 5
	SHOW
	CLRALL
;stage 4
	LDXYZ 3,0,0
	LINE 1,1,0,2
	LINE 0,1,1,4
	LINE 0,-1,1,2
	LINE -1,-1,0,4
	LINE -1,1,0,2
	LINE 0,1,-1,4
	LINE 0,-1,-1,2
	LINE 1,-1,0,4
	LDR RHOLD, 5
	SHOW
	CLRALL
;stage 5
	LDXYZ 4,0,0
	LINE 0,1,1,5
	LINE -1,-1,0,5
	LINE 0,1,-1,5
	LINE 1,-1,0,5
	LDR RHOLD, 5
	SHOW
	CLRALL
;stage 6
	LDXYZ 4,0,1
	LINE 0,1,1,4
	LDXYZ 3,4,4
	LINE -1,-1,0,4
	LDXYZ 0,0,3
	LINE 0,1,-1,4
	LDXYZ 1,4,0
	LINE 1,-1,0,4
	LDR RHOLD, 5
	SHOW
	CLRALL
;stage 7
	LDXYZ 4,0,2
	LINE 0,1,1,3
	LINE -1,1,0,3
	LINE -1,-1,0,3
	LINE 0,-1,-1,3
	LINE 0,1,-1,3
	LINE 1,1,0,3
	LINE 1,-1,0,3
	LINE 0,-1,1,3
	LDR RHOLD, 5
	SHOW
	CLRALL
;stage 8
	LDXYZ 4,0,3
	LINE 0,1,1,2
	LINE -1,1,0,4
	LINE -1,-1,0,2
	LINE 0,-1,-1,4
	LINE 0,1,-1,2
	LINE 1,1,0,4
	LINE 1,-1,0,2
	LINE 0,-1,1,4
	LDR RHOLD, 5
	SHOW
	CLRALL

	SKIPTOUT
	JUMP HELIX_LOOP1
	RET

;-------------------------------------------------
MAGNET
	LDTMR 10
	ADDTRND 10
	CLRALL
	MSET
	RANDSEED
	LDR R1,1
	JUMP CHOOSEN
CHOOSEN
	CMP R1,1
	SKIPNZ
	JSR LEFT_INIT
	CMP R1,26
	SKIPNZ
	JSR RIGHT_INIT
	SKIPTOUT
	JUMP CHOOSEN
	RET
MAGNET_INIT
	LDRAND RY,5
	LDRAND RZ,5
	LDR RHOLD, 1
	PUSHR RHOLD
	LDRAND RHOLD,12
	PUSHR RHOLD
	ADD
	PULLR RHOLD
	RET

LEFT_INIT
	LDR RHOLD, 100
	LDXYZ 0,0,0
	PLANEX
	SHOW
	JSR INCMAG
	RET
RIGHT_INIT
	LDR RHOLD, 100
	LDXYZ 4,4,4
	PLANEX
	SHOW
	JSR DECMAG
	RET

INCMAG
	JSR MAGNET_INIT
	LDR R0,4
	LDR RX,0
	TSTVOX
	SKIPZ
	INCR R1
	TSTVOX
	SKIPZ
	JSR MAGNETRIGHT
	CMP R1,26
	SKIPNZ
	RET
	JUMP INCMAG

DECMAG
	JSR MAGNET_INIT
	LDR R0,4
	LDR RX,4
	TSTVOX
	SKIPZ
	DECR R1
	TSTVOX
	SKIPZ
	JSR MAGNETLEFT
	CMP R1,1
	SKIPNZ
	RET
	JUMP DECMAG

MAGNETRIGHT
	MCLR
	VOXM
	INCX
	MSET
	VOXM
	SHOW
	DECRSZ R0
	JUMP MAGNETRIGHT
	RET

MAGNETLEFT
	MCLR
	VOXM
	DECX
	MSET
	VOXM
	SHOW
	DECRSZ R0
	JUMP MAGNETLEFT
	RET
;----------------------------------------------------
BOUNCE_FILL
	CLRALL
	MCLR
	MSET
	LDTMR 7
	ADDTRND 6
MAIN_PROG
	LDR RHOLD, 9
	VOX 4,4,4
	SHOW
	LDR R1,0		;RESET REVERSE
	LDR R0,4
	JSR MOVEXYZ
	LDR RHOLD,4
	JSR FILL_LOOP
	LDR R1,1
	JSR END_VOX
	JSR FILL_LOOP
	SKIPTOUT
	JUMP MAIN_PROG
	RET
FILL_LOOP
	JSR STAGE1
	JSR STAGE2
	JSR STAGE3
	JSR STAGE4
	JSR STAGE5
	JSR STAGE6
	JSR STAGE7
	JSR STAGE8
	JSR STAGE9
	JSR STAGE10
	JSR STAGE11
	JSR START_VOX
	RET
;------------
STAGE1
	VOX 1,0,0
	VOX 0,0,1
	VOX 0,1,0
	JSR S_H
	RET
STAGE2
	VOX 0,2,0
	VOX 1,1,0
	VOX 0,1,1
	LDXYZ 2,0,0
	LINE -1,0,1,3
	JSR S_H
	RET
STAGE3
	VOX 0,3,0
	VOX 1,2,0
	VOX 0,2,1
	LDXYZ 2,1,0
	LINE -1,0,1,3
	LDXYZ 3,0,0
	LINE -1,0,1,4
	JSR S_H
	RET
STAGE4
	VOX 0,4,0
	VOX 1,3,0
	VOX 0,3,1
	LDXYZ 2,2,0
	LINE -1,0,1,3
	LDXYZ 3,1,0
	LINE -1,0,1,4
	LDXYZ 4,0,0
	LINE -1,0,1,5
	JSR S_H
	RET
STAGE5
	VOX 4,0,1
	VOX 3,0,2
	VOX 2,0,3
	VOX 1,0,4
	LDXYZ 4,1,0
	LINE -1,0,1,5
	LDXYZ 3,2,0
	LINE -1,0,1,4
	LDXYZ 2,3,0
	LINE -1,0,1,3
	VOX 1,4,0
	VOX 0,4,1
	JSR S_H
	RET
STAGE6
	LDXYZ 4,0,2
	LINE -1,0,1,3
	LDXYZ 4,1,1
	LINE -1,0,1,4
	LDXYZ 4,2,0
	LINE -1,0,1,5
	LDXYZ 3,3,0
	LINE -1,0,1,4
	LDXYZ 2,4,0
	LINE -1,0,1,3
	JSR S_H
	RET
STAGE7
	VOX 4,0,3
	VOX 3,0,4
	LDXYZ 4,1,2
	LINE -1,0,1,3
	LDXYZ 4,2,1
	LINE -1,0,1,4
	LDXYZ 4,3,0
	LINE -1,0,1,5
	LDXYZ 3,4,0
	LINE -1,0,1,4
	JSR S_H
	RET
STAGE8
	VOX 4,0,4
	VOX 4,1,3
	VOX 3,1,4
	LDXYZ 4,2,2
	LINE -1,0,1,3
	LDXYZ 4,3,1
	LINE -1,0,1,4
	LDXYZ 4,4,0
	LINE -1,0,1,5
	JSR S_H
	RET
STAGE9
	VOX 4,1,4
	VOX 4,2,3
	VOX 3,2,4
	LDXYZ 4,3,2
	LINE -1,0,1,3
	LDXYZ 4,4,1
	LINE -1,0,1,4
	JSR S_H
	RET
STAGE10
	VOX 4,2,4
	VOX 4,3,3
	VOX 3,3,4
	LDXYZ 4,4,2
	LINE -1,0,1,3
	JSR S_H
	RET
STAGE11
	VOX 4,3,4
	VOX 4,4,3
	VOX 3,4,4
	JSR S_H
	RET
START_VOX
	VOX 4,4,4
	SHOW
	RET
;------------
END_VOX
	VOX 0,0,0
	MCLR
	VOXM
	SHOW
	RET
S_H
	SHOW
	CMP R1,1
	SKIPNZ
	MINV
	SHOW
	RET
MOVEXYZ
	MCLR
	VOXM
	DECX
	DECY
	DECZ
	MSET
	VOXM
	SHOW
	DECRSZ R0
	JUMP MOVEXYZ
	RET

