;--------------------------------------------------------
; 5mS Time Out
; This code loops continually and then calls _timerOut function
; approximately every 5mS

_waitTimeout	movf	intCount,F	; Test count of 416uS interrupts
	bnz	_waitTimeout	; wait until timeout occurs
	movlw	cINTCOUNT	; load counter constant into W
	movwf	intCount	; and reload counter
	call	_timerOut	; call timeout functions
	goto	_waitTimeout	; and loop
 

_timerOut	decf	mustSend,F	; Decrement the 'mustSend' counter
			; This is reset everytime a packet is
			; sent. If RGB data is static this counter
			; will rollover and force a packet to be sent
			; every 416uS x cINTCOUNT x 256 ~= 1.1S

;-----------------------------------------------------
; EEPROM save counter
; Update EEPROM  with current sequence number about 5 seconds after
; sequence select switch last pressed.
;
	movf	saveCnt,F	
	bz	_switchCheck
	decfsz	saveCntPS,F
	goto	_switchCheck
	decfsz	saveCnt,F
	goto	_switchCheck
	movfw	currentSeqNo
	call	_eeWrite	
	
;-----------------------------------------------------
; Sequence Switch Check

_switchCheck	btfsc	GPIO,seqSw
	goto	_seqSwUp	
		
_seqSwDown	incf	seqSwCnt,F	; increment seqSwCnt counter variable

	goto	_fadeState

_seqSwUp	movlw	-.4	; 20mS
	addwf	seqSwCnt,W	; was switch down for over 20mS
	bc	_swShort
	clrf	seqSwCnt
	goto	_fadeState
	
_swShort	call	_advSeq	; advance to next sequence
	call	_seqData	; get first set of sequence data
	clrf	rpwm	; reset current Red pwm to 0
	clrf	gpwm	; reset current Green pwm to 0
	clrf	bpwm	; reset current Blue pwm to 0
	call	_fadeDir	; set fade direction
	movlw	cHOLDPRESCALER	; reset hold time prescaler
	movwf	holdTimerPS
	clrf	seqSwCnt
	movlw	cSAVETIMER	; set save to EEPROM timer
	movwf	saveCnt	; for delay after last sequence change.
		

;-----------------------------------------------------
; fade / hold state function select
	
_fadeState	movf	fadeflag,F
	bz	_holding
	
;------------------------------------------------------
; fade	
	
_fading	decfsz	fadeTimer,F
	return
	movfw	rate
	movwf	fadeTimer

;----------------------------------------
; Fade stepper
;
_Rfade	movfw	rnew
	xorwf	rpwm,W
	bnz	$+3
	bcf	fadeflag,red
	goto	_Gfade

	movfw	Rdif
	addwf	Rcnt,F
	skpc	
	goto	_Gfade
	movfw	CntBase
	addwf	Rcnt,F
	movfw	rdir
	addwf	rpwm,F
	
_Gfade	movfw	gnew
	xorwf	gpwm,W
	bnz	$+3
	bcf	fadeflag,green
	goto	_Bfade

	movfw	Gdif
	addwf	Gcnt,F
	skpc	
	goto	_Bfade
	movfw	CntBase
	addwf	Gcnt,F
	movfw	gdir
	addwf	gpwm,F

_Bfade 	movfw	bnew
	xorwf	bpwm,W
	bnz	$+3
	bcf	fadeflag,blue
	return
	
	movfw	Bdif
	addwf	Bcnt,F
	skpc	
	return	
	movfw	CntBase
	addwf	Bcnt,F
	movfw	bdir
	addwf	bpwm,F
	return


;------------------------------------------------------
; Hold pwm values timer	
	
_holding	movf	holdTimerHi,F	; test holdTimerHi == 0
	bz	_holdSeqNext	; no hold if it was 0
	
	decfsz	holdTimerPS,F
	return
	movlw	cHOLDPRESCALER
	movwf	holdTimerPS
	decfsz	holdTimerHi,F
	return
_holdSeqNext	call	_seqData
	call	_fadeDir
	
	return

