; ***************************************************************************************
; 2400bps Serial RGB data controller (Internet release)
; Production Code 2.0.0 (24/07/2006)
; Pete Griffiths (c) 2006
; Written and assembled using MPLAB v7.21
;
; This code will run on 12F629 / 12F675 and 12F683. Select the desired processor
; from the Configure - Select Device menu option in MPLAB IDE, then use the
; Project - Quickbuild option to create the .HEX output file.
; 
; Look for errors during assembly. In particular errors in the SequenceData.inc
; file that indicate either a missing comma in the data, or more data than the 
; chosen PIC has available program memory.
; 
; Be carefull to enter the data in the SequenceData.inc file correctly.  The program
; is only smart enough to work out where your sequences start and finish if you enter
; it in the correct format.  Errors may cause the code to crash.
;
; ***************************************************************************************
; Note: For 12F629 and 12F675
; All timings are based on the internal 4Mhz PIC oscillator.  The OSCCAL value is read
; from program memory at 0x3FF and written to the OSCAL register.  This value must be
; present and correct. 
;
;             -=# IF IT IS MISSING THE CODE WILL NOT RUN CORRECTLY #=-
;
; This does not apply to 12F683 as it doesn't use this method to calibrate the oscillator
;
; ***************************************************************************************
; Ensure that GPIO3 is either driven or tied but NOT LEFT FLOATING
;	        ___ ___
;  	   Vdd -|1 ^ 8|- Vss
;  Sequence Change Sw  -|2   7|- bit clock output
;          Serial Txd  -|3   6|- unused (weak-pull up enabled)
;  unused. tie to  Vdd -|4   5|- unused (weak-pull up enabled)
;	        
;
; The bit clock output is toggled by the serial transmission function.
; This is a 7uS pulse that occurs at the same frequency as the bit rate.  If the PIC internal 
; oscillator is correctly calibrated the bit clock output should pulse at 2.4Khz for 2400bps
; 
; ***************************************************************************************
; V2 uses a refined fading algorithm
;
; ***************************************************************************************

  IFDEF  __12F683
	#include "p12f683.inc"
	#define ADCpresent
  ENDIF

          
  IFDEF  __12F675
	#include "p12f675.inc"
	#define ADCpresent
  ENDIF

  IFDEF  __12F629
	#include "p12f629.inc"
	
  ENDIF
	errorlevel -302	; suppress banksel warning messages
  IFDEF __12F683	
     __CONFIG       _CP_OFF & _WDT_OFF & _BOD_OFF &_PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
  ELSE
     __CONFIG       _CP_OFF & _WDT_OFF & _BODEN_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
  ENDIF
  
  	errorlevel -302	; suppress banksel warning messages
       
; Program data memory variables
; --------------------------------------------
;          
	cblock	0x20 
	 	 
	 sbl	; Sequence Base Low
	 sbh	; Sequence Base High
	 seql	; Current Sequence data pointer Low
	 seqh	; Current Sequence data pointer High
	 currentSeqNo	; Current Sequence No
	 highSeqNo	; Highest Sequence No
	 savedSeqNo	; saved Sequence No read from EEPROM
	 rate	; Fade rate
	 hold	; Sequence hold time
	 rnew	; red data
	 gnew	; green data
	 bnew	; blue data
	 seqSwCnt	; sequence switch counter
	 saveCntPS	; save to EERPOM counter prescaler
	 saveCnt	; save to EEPROM counter 
	 fadeTimer	; fade rate timer counter
	 holdTimerPS	; hold timer prescaler
	 holdTimerHi	; hold timer counter
	 rdir	; red fade direction
	 rpwm	; red pwm level
	 rcmp	; red compare for change
	 gdir	; green fade direction
	 gpwm	; green pwm level
	 gcmp	; green compare for change
	 bdir	; blue fade direction
	 bpwm	; blue pwm level
	 bcmp	; blue compare for change
	 fadeflag	; fade complete flag variable
	 pwmramp	; pwm ramp counter
	 driveLevel	; select drive level
	 intCount	; Interrupt count
	 mustSend	; Counter forces packet send if RGB data static
	 Rcnt
	 Gcnt
	 Bcnt
	 Rdif
	 Gdif
	 Bdif
	 CntBase
	 
	 data1
	 data2
	 data3	
	 chksum	; packet checksum, computed by _sendPacket
	 TxdSent	; 0 = Sending, 1 = Sent
 	 serialState	; serial state machine 
 	 txByte	; byte serializer 
 	 pktSent	; packet sent flag: 0 = sending: 1 = completed
 	 packetState	; packet state machine 
	 bitCounter	; serializer bit counter
	 save_W	; Save registers in interrupt handler
	 save_Status	; Save registers in interrupt handler
	 save_PCLATH	; Save registers in interrupt handler
	 save_FSR	; save copy of FSR used outside interrupt
	 int_FSR	; save copy of FSR used within interrupt
	  	
	endc
	
;----------------------------------------------------------
; program Constants - DO NOT change them

cHOLDPRESCALER	equ	.10	; rgb hold counter prescaler
			; 5mS x Prescaler x holdtime
				
cSAVETIMER	equ	.3	; time after last seq switch change
			; before saving to EEPROM
			; in increments of 1.28S
			

;bitClock	equ	.209	; Timer value for 104uS bit clock (9600bps) PS=1
cBITCLOCK	equ	.57	; Timer value for 416uS bit clock (2400bps) PS=2
			; Timer value allows for latency between timer rollover
			; and timer reload in the interrupt handler (~16uS)

cINTCOUNT	equ	.11	; Count of 416uS interrupts
			
red	equ	.0
green	equ	.1
blue	equ	.2
;----------------------------------------------------------
; GPIO port variables - DO NOT change them
bitclock	equ	.0	; bit rate software clock output (for debugging).
gpio1	equ	.1	; set to input but not used 
gpio2	equ	.2	; set to input but not used
gpio3	equ	.3	; input only but not used (Tie to Vss)
Txd	equ	.4	; Transmit data (TxD) output
seqSw	equ	.5	; Sequence select switch input
	
;----------------------------------------------------------
;
;
; Bank Select macro instructions
#define	setbank0	bcf	STATUS,RP0	; Sel Bank 0
#define	setbank1	bsf	STATUS,RP0	; Sel Bank 1
	
	org 0x000	; reset vector
	goto	_startup
	
	org 0x004	; interrupt vector
	include	rgbsync_int.inc		; This interrupt function must follow previous directive
	include	rgbsync_startup.inc
	include	rgbsync_functions.inc
	include	rgbsync_timerout.inc
	radix decimal
_base
	include	SequenceData.inc

;	------------------------------------------------------------------------
	; Embed code revision into program memory
	dt "rgbsync_ctrl.asm 13/08/2006 "  
	dt "(c) Pete Griffiths 2006 "
	dt "rgbsync_ctrl@petesworld.demon.co.uk" 
	dt "For non-commercial and not-for-profit use only"
;	------------------------------------------------------------------------


	;fill 00, 0x3FF-$
	
	end

