;

;	Sequence Data Format
;               -------------------
;	fade_rate, hold_time, red, green, blue (all values in decimal)
;	values should be 0 <= value <= 255
;
;	End of current sequence
;	-----------------------
;	fade_rate = 255 tells code that this is then end of the current
;	sequence data.
;
;	End of all sequence data
;	------------------------
;	fade_rate and hold_time = 255 tells the code that this is the end
; 	of the current sequence data AND the end of all sequences.
;	
;	Fade Rate
;	---------
;	fade_rate = 0 --> no fade, new values update immediateley
;	fade_rate >0 and <255 fades from current to new values. 
;	The colours fade from the current value to the new value
;	in steps of 1 (i.e. 0 to 100 requires 100 steps)
;	each step takes ~5mS x Fade Rate.
;
;	max fade time with increments of 5mS x fade_rate. 
;	1 x 5mS x 255 = 1.27 secs
;	2 x 5mS x 255 = 2.50 secs
;	3 x 5mS x 255 = 3.85 secs
;	4 x 5mS x 255 = 5.10 secs
;	5 x 5mS x 255 = 6.35 secs
; 	6 x 5mS x 255 = 7.60 secs
;               ......
;               254 x 5mS x 255 = 3m23s 
;
;	Hold Time
;	---------
;	How long to hold the current RGB colours before getting
; 	the next set of RGB values.
; 	hold_time = 0 --> no hold, jump to next step in sequence
;	hold_time >0 and <255 hold for 50ms x hold_time
;	1   x 50mS = 50mS
;	254 x 50mS = 12.7 secs
#define	cRed	255,0,0
#define	cGreen	0,255,0
#define	cBlue	0,0,255

#define	black	0,0,0
#define	silver	192,192,192
#define	grey	128,128,128
#define	white	255,255,255

#define	yellow	255,255,0
#define	cyan	0,255,255	; sky blue
#define	magenta	255,0,255	; purple

#define	orange	255,102,0
#define	darkred	139,0,0

#define	olive	85,107,47
#define	lime	50,205,50
#define	turquoise	64,224,208
#define	skyblue	135,206,255
#define	indigo	75,0,130
#define	pink	255,181,197
#define	crimson	220,20,60
#define	slate	112,128,144
#define	gold	255,215,0
#define	brown	139,69,19
#define	tan	255,165,79
;
;	    ________________ Fade Rate
;                  |   _____________ Hold time     
;                  |  |    _________ Red
;                  |  |   |     ____ Green
;                  |  |   |    |   _ Blue  
;                  |  |   |    |  |

	dt 0,0, cBlue
	dt 2,0, black
	dt 0,0, cRed
	dt 2,0, black
	dt 0,0, cGreen
	dt 2,0, black

	dt 255
	
	dt 0,10,cRed
	dt 255

	dt 0,10,cGreen
	dt 255
	
	dt 0,10,cBlue
	dt 255

	dt 0,10, cyan
	dt 255
	
	dt 0,10, magenta
	dt 255
	
	dt 0,10, yellow
	dt 255
	

	dt 3,5, cGreen
	dt 3,5, cyan
	dt 3,5, cBlue
	dt 3,5, magenta
	dt 3,5, cRed
	dt 3,5, yellow
	dt 255


	dt 10,0, olive
	dt 10,0, lime
	dt 10,0, turquoise
	dt 10,0, skyblue
	dt 10,0, indigo
	dt 10,0, crimson
	dt 10,0, gold
	dt 10,0, brown
	dt 10,0, tan
	dt 10,0, orange
	dt 255

	dt 2,200, cRed
	dt 2,200, yellow
	dt 2,200, cGreen
	dt 2,200, cyan
	dt 2,200, cBlue
	dt 2,200, magenta
	dt 255


	dt 20,0, yellow
	dt 20,0, cGreen
	dt 20,0, cyan
	dt 20,0, cBlue
	dt 20,0, magenta
	dt 20,0, cRed
	dt 255
	

	dt 15,0, orange
	dt 20,0, magenta
	dt 15,0, indigo
	dt 20,0, cRed
	dt 255


	dt 0,1, cRed
	dt 0,1, cGreen
	dt 0,1, cBlue
	dt 0,2, cRed
	dt 0,2, cGreen
	dt 0,2, cBlue
	dt 255

	
	dt 0,1, cRed
	dt 0,3, black
	dt 0,1, cGreen
	dt 0,3, black
	dt 0,1, cBlue
	dt 0,3, black
	dt 0,2, magenta
	dt 0,3, black
	dt 0,2, cyan
	dt 0,3, black
	dt 0,2, yellow
	dt 255
	
	
	dt 8,0,magenta
	dt 8,0,pink
	dt 8,0,crimson
	dt 8,0,indigo
	dt 8,0,turquoise
	dt 8,0,cyan
	dt 8,0,skyblue
	dt 8,0,yellow
	dt 8,0,brown
	dt 8,0,olive
	dt 255


	dt 10,200,magenta
	dt 10,200,cRed
	dt 10,200,yellow
	dt 10,200,crimson
	dt 10,200,indigo
	dt 10,200,turquoise
	dt 10,200,cyan
	dt 10,200, cBlue
	dt 10,200,skyblue

	dt 10,200,brown
	dt 10,200,cGreen
	dt 10,200,lime
	
	dt 255
	
	


	dt 0,5, 0,0,10
	dt 0,5, 0,0,0
	dt 255		; end of sequence
	dt 255		; end of all data


