;===============================================================================	
; Serial IO transmit and receive byte routines
; For 16F627A / 628A
; USART and BRG must have been initialised prior to use
;
;===============================================================================	
; Transmit character in W 
; W is preserved
_serialTX	btfss	PIR1,TXIF	;test TX buffer flag status	
	 goto	_serialTX	;loop until buffer clear for new data
	movwf	TXREG	;write character in W to TXREGister
	return		;and return
;===============================================================================	
; Receive character into W
; check for receive buffer errors
; return with valid received character in W
	
_serialRX	btfss	PIR1,RCIF	;test RX flag status
 	 goto	_serialRX	;loop until data received
	movfw	RCREG	;read received data into W
	btfsc	RCSTA,FERR	;test framing error flag
	 goto	_error	;
	btfss	RCSTA,OERR	;test buffer overrun error flag
	 return		;if no error return with W=received data
_error	bcf	RCSTA,CREN	;disable and then enable continous receive	
	bsf	RCSTA,CREN	;to clear receive buffer errors.
	goto	_serialRX	;go back and try again
