;----------------------------------------------------------------------------
; Functions to set output bits
; Code not portable. Used in SerialTerm and TempTerm
;
; _byteSetCode	Sets outputReg to specified bit pattern
; _onCode	Set single bit in outputReg, or Set all bits
; _offCode	Clear single bit in outputReg, or Clear all bits
; _toggleCode	Toggle single bit in outputReg, or Toggle all bits
;
; memory variables used
;  outputReg
;  outputTmp
;  bufferpos
;  returnStatus
;  binary
;  Also uses FSR / INDF registers
;----------------------------------------------------------------------------
;Command sets output port to binary bit value specified in command
; syntax is: Snnnnnnnn/
; Command must contain S, followed by 8 characters [0 or 1] followed by /
;

_byteSetCode	movlw	bufferpos + 9	;set buffer position to 9
	movwf	FSR	
	movf	INDF,w	;get buffer character in W
	xorlw	0x2f	;and test for '/' 
	bnz	_badCLI	;if !=0 then do bad command
	movlw	bufferpos + 1	;set buffer pointer to second char'
	movwf	FSR	
	
_byteSetLoop	clrc		;pre clear carry
	movfw	INDF	;move buffer char' into W
	xorlw	0x30	;test for ASCII '0'
	bz	_byteSetBit0	;buffer was ASCII '0' so skip test for '1'
	movfw	INDF	;move buffer char' into W
	xorlw	0x31	;test for ASCII '1'
	bnz	_badCLI	;Buffer not 0 or 1 so command is bad
	setc		;Char was '1' so set carry
_byteSetBit0	rlf	outputTmp,f	;shift carry into outputTmp 
	incf	FSR,f	;increment buffer pointer
	movf	INDF,w	;load buffer char' into W
	xorlw	0x2f	;test for 0x2f '/' char'
	bnz	_byteSetLoop	;keep going until buffer '/' delimiter
	movfw	outputTmp	;put outputTmp in W
	movwf	outputReg	;write to outputReg
	movwf	OUT_PORT	;and output port
	return
	
;******************************************************************
;Set output 
;Takes one character from input buffer, anything else is ignored.	
;
_onCode	call	_bitData
	movf	returnStatus,F	;Test return status
	skpz		;skip if okay
	goto	_badCLI	;else goto bad Command exit
	iorwf	outputReg,F	;OR outputReg with W
	movfw	outputReg	;load W with outputReg
	movwf	OUT_PORT	;write data to output port
	return
;******************************************************************
;Clear output 
;Takes one character from input buffer, anything else is ignored.	
;
_offCode	call	_bitData
	movf	returnStatus,F	;Test return status
	skpz		;skip if okay
	goto	_badCLI	;else goto bad Command exit
	xorlw	0xFF	;invert the bits returned from _bitData 
	andwf	outputReg,F	;AND outputReg with W
	movfw	outputReg	;load W with outputReg
	movwf	OUT_PORT	;write data to output port
	return
;******************************************************************
;Toggle output 
;Takes one character from input buffer, anything else is ignored.
;		
_toggleCode	call	_bitData
	movf	returnStatus,F	;Test return status
	skpz		;skip if okay
	goto	_badCLI	;else goto bad Command exit
	xorwf	outputReg,F	;Exclusive OR outputReg with W
	movfw	outputReg	;load W with outputReg
	movwf	OUT_PORT	;write data to output port
	return
	
;******************************************************************
;Common code for bit set/clear/toggle
;
_bitData	incf	FSR,f	;point to next char' in buffer
	movfw	INDF	;load in W
	call	_a2h	;convert to binary
	movf	returnStatus,f	;test validity
	skpz		;if returnStatus =0 data is good
	return		;else data invalid, return to call
	movlw	0x09	;load W with 9
	subwf	binary,W	;subtract from binary
	bnc	_bitTable	;if >8 invalid, get out
	incf	returnStatus,f	;increment returnStatus to make it !=0
	return		;return to call
		
_bitTable	movlw	high _bitData	;get PCLATH at assembly time
	movwf	PCLATH	;write to PCLATH
	movfw	binary	;load W with value in binary
	addwf	PCL,f
	retlw	b'11111111'	;if 0 do to all bits
	retlw	b'00000001'	;if 1 do to bit 0
	retlw	b'00000010'	;if 2 do to bit 1
	retlw	b'00000100'	;if 3 do to bit 2
	retlw	b'00001000'	;if 4 do to bit 3	
	retlw	b'00010000'	;if 5 do to bit 4
	retlw	b'00100000'	;if 6 do to bit 5
	retlw	b'01000000'	;if 7 do to bit 6
_bitTableEnd	retlw	b'10000000'	;if 8 do to bit 7

	if high _bitTable != high _bitTableEnd
	  messg " ATTENTION: routine '_bitTable' is crossing a page boundary "
	endif
