; ********************************************************************************
; RGB Standalone LED driver for 350mA Zetex driver PCB
; Release Code 1.0.0 (19/04/2007)
; Pete Griffiths (c) 2007
; Written and assembled using MPLAB v7.52
;
; Code to fade between colours is completely rewritten to use variable rate of change
; so that all three LEDs arrive at their new levels simultaneously.
;
; This code will run on 12F629 / 12F675 and 12F683. Select the desired processor
; from the Configure - Select Device menu option in MPLAB IDE, then use the
; Project - Quickbuild option to create the .HEX output file.
; 
; Look for errors during assembly. In particular errors in the SequenceData.inc
; file that indicate either a missing comma in the data, or more data than the 
; chosen PIC has available program memory.
; 
; Be carefull to enter the data in the SequenceData.inc file correctly.  The program
; is only smart enough to work out where you sequences start and finish if you enter
; it in the correct format.  Errors may cause the code to crash.
;
; ********************************************************************************
; Note: For 12F629 and 12F675
; All timings are based on the internal 4Mhz PIC oscillator.  The OSCCAL value is read
; from program memory at 0x3FF and written to the OSCAL register.  This value must be
; present and correct. 
;
;             -=# IF IT IS MISSING THE CODE WILL NOT RUN CORRECTLY #=-
;
; This does not apply to 12F683 as it doesn't use this method to calibrate the oscillator
;
; ********************************************************************************
; Ensure that GPIO3 is either driven or pulled up but NOT LEFT FLOATING
;                        ___ ___
;                   Vdd -|1 ^ 8|- Vss
;  Sequence Change Sw1  -|2   7|- red
;           unused Sw2  -|3   6|- green
;  MCLR.    tie to  Vdd -|4   5|- blue
;                        
;
; IMPORTANT: When not connected to the programmer MCLR must be tied high by placing
; a jumper between the Vpp and 5V pins of the ICSD header
; ********************************************************************************
; Revision information
; rgbsa-350inet.asm version 1.0.0
;
;
; ********************************************************************************

  IFDEF  __12F683
                #include "p12f683.inc"
                #define ADCpresent
  ENDIF

          
  IFDEF  __12F675
                #include "p12f675.inc"
                #define ADCpresent
  ENDIF

  IFDEF  __12F629
                #include "p12f629.inc"
                
  ENDIF

  IFDEF __12F683                
     __CONFIG       _CP_OFF & _WDT_OFF & _BOD_OFF &_PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_ON & _CPD_OFF
  ELSE
     __CONFIG       _CP_OFF & _WDT_OFF & _BODEN_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_ON & _CPD_OFF
  ENDIF
  
                errorlevel -302 ; suppress banksel warning messages
       
; Program data memory variables
; --------------------------------------------
;          
                cblock          0x20 
                                 
                 sbl            ; Sequence Base Low
                 sbh            ; Sequence Base High
                 seql           ; Current Sequence data pointer Low
                 seqh           ; Current Sequence data pointer High
                 currentSeqNo   ; Current Sequence No
                 highSeqNo      ; Highest Sequence No
                 savedSeqNo     ; saved Sequence No read from EEPROM
                 rate           ; Fade rate
                 hold           ; Sequence hold time
                 rnew           ; red data
                 gnew           ; green data
                 bnew           ; blue data
                 seqSwCnt       ; sequence switch counter
                 saveCntPS      ; save to EERPOM counter prescaler
                 saveCnt        ; save to EEPROM counter 
                 fadeTimer      ; fade rate timer counter
                 holdTimerPS    ; hold timer prescaler
                 holdTimerHi    ; hold timer counter
                 rdir           ; red fade direction
                 rpwm           ; red pwm level
                 gdir           ; green fade direction
                 gpwm           ; green pwm level
                 bdir           ; blue fade direction
                 bpwm           ; blue pwm level
                 Rdif           ; absolute difference between red now and next
                 Gdif           ; absolute difference between green now and next
                 Bdif           ; absolute difference between blue now and next
                 Rcnt           ; fade step counter red
                 Gcnt           ; fade step counter green
                 Bcnt           ; fade step counter blue
                 CntBase        ; fade base count holding variable
                 
                 fadeflag       ; fade complete flag variable
                 pwmramp        ; pwm ramp counter
                 driveLevel     ; select drive level
                                
                endc
                
;----------------------------------------------------------
; program Constants - DO NOT change them
cTIMER          equ             .179            ; Timer 0 constant 
                                                ; for 5mS timer tick

cHOLDPRESCALER  equ             .10             ; rgb hold counter prescaler
                                                ; 5mS x Prescaler x holdtime
                                                                
cSAVETIMER      equ             .8              ; time after last seq switch change
                                                ; before saving to EEPROM
                                                ; in increments of 1.28S

cDriveLevel     equ             0               ; 0 = output low turns LED on
                                                ; 1 = ouput high turns LED on

;----------------------------------------------------------
; GPIO port variables - DO NOT change them
red             equ             0               ;out
green           equ             1               ;out
blue            equ             2               ;out
gpio3           equ             3               ;in (only)
optSw           equ             4               ;in
seqSw           equ             5               ;in
                
;----------------------------------------------------------
;
;
; Bank Select macro instructions
#define         setbank0        bcf             STATUS,RP0      ; Sel Bank 0
#define         setbank1        bsf             STATUS,RP0      ; Sel Bank 1
                
                org 0x000
                
                include         rgbstartup350.inc
                include         rgbsa_functions350.inc
                include         timerout350.inc
                radix decimal
_base
                include         SequenceData350.inc

;               ------------------------------------------------------------------------
                ; Embed code revision into program memory
                dt "rgbsa_inet350.asm 19/04/2007 R1.0.0"  
                dt "(c) Pete Griffiths 2006-2007 "
                dt "info@picprojectsorg.uk"
;               ------------------------------------------------------------------------


                
                ;fill 00, 0x3FF-$
                
                end

