; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~#
; F1 style race starting lights
; http://picprojects.org.uk
; Pete Griffiths (c) 2005-2010
; December 2005
;
; For personal, non-commercial use only.
;
; Version 1.01
;
; Note:
; Minor modification to code tha puts the PIC to sleep between starts so
; that an on/off power switch isn't needed.
; 
; Written and assembled using Microchip MPLAB IDE v7.21
; set tabs at 14 columns to make it line up nice :-)
;
; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~#
;
	#include "p16f627a.inc"	

	__CONFIG       _CP_OFF & _WDT_OFF & _BOREN_OFF & _PWRTE_ON & _INTOSC_OSC_NOCLKOUT  & _MCLRE_OFF & _LVP_OFF

               
	errorlevel -302	; suppress banksel warning messages
	cblock 0x20

	 
 	endc
	
	cblock 0x70	;0x70-0x7F common to all banks
	 save_W	;0.  save W during interupt
	 save_Status	;1.  save STATUS during interupt
	 save_PCLATH	;2.  save PCLATH
	 tick	;3.  timer0 ticks at 18.0011hz
	 startDelay   ;4   random start delay
	 seconds	;5   decremented every second
	 secFlag	;6   flag is set by Int Handler at each second
	 lights	;7   lights output working variable

	endc
	
	
#define	bank0	bcf	STATUS,RP0	; Sel Bank 0
#define	bank1	bsf	STATUS,RP0	; Sel Bank 1


timerConst	EQU	d'40'
timerTicks	EQU	d'19'
;timerConst	EQU	d'254'
;timerTicks	EQU	4

;=============================================================
;=============================================================
	org	0x000	;RESET VECTOR
	goto	_startup	;goto to startup code on reset
		
	org	0x004	;INTERUPT VECTOR
	include	f1-interrupt.inc ;must go here

; ************************************************************
; include code blocks			;*
; ************************************************************
; ************************************************************
;
; Initialise peripherals and registers at startup
;
_startup	movlw	0x07
	movwf	CMCON	;disable comparator
	
	movlw	0x0A
	movwf	lights
	call	_output	; turn on Lights 2 and 4
	
	bank1
	
	movlw	b'11100000'
	movwf	TRISA	;RA0-4 Light outputs 1-5
	
	movlw	b'11111111'	
	movwf	TRISB	;RB0 
			;RB1 
			;RB2 
			;RB3
			;RB4 start key switch input 
			;RB6 
			;RB7 

	;all unused I/O lines on both ports are set to input and should be tied to Vss

	
_setOptReg	movlw	b'00000111'	;setup option register
	;	  ||||||||---- PS0 - Timer 0: Prescalar 1:256
	;	  |||||||----- PS1
	;	  ||||||------ PS2
	;	  |||||------- PSA -  Assign prescaler to Timer0
	;	  ||||-------- TOSE - LtoH edge
	;	  |||--------- TOCS - Timer0 uses IntClk
	;	  ||---------- INTEDG - falling edge RB0
	;	  |----------- RBPU - pull-ups enabled
	movwf	OPTION_REG

	bank0
	
_setTimer1	movlw	b'00000001'	;we use this free running timer
	movwf	T1CON	;as random number for start delay 
	


		


;==============================================================

_waitKey	bcf	INTCON,GIE	; disable global ints
	bsf	INTCON,RBIE	; enable Port B change ints
	movf	PORTB,F	; read Port B
	bcf	INTCON,RBIF	; clear Port B change flag
	sleep		; goto sleep
	nop
	movf	PORTB,F	; read Port B
	bcf	INTCON,RBIF	; clear Port B change flag
	bcf	INTCON,RBIE	; disable Port B chnage ints

_waitRelease	btfss	PORTB,4	;skip next when key released
	goto	_waitRelease  ;loop until key released
	
	
_Countdown	movlw	timerConst
	movwf	TMR0	;preset timer
	movlw	timerTicks
	movwf	tick	;preset ticks
	movlw	0x05	
	movwf	seconds	;set 5 seconds countdown
	clrf	secFlag	;clear seconds change flag
	bcf	INTCON,T0IF	;clear TimerO int flag
	movlw	b'10100000'	;enable interupts for TMR0 
	movwf	INTCON	;
	
	clrf	lights
_nextLight	bsf	STATUS,C	; set the carry 
	rlf	lights,F	; rotate carry into LSB of lights var'
	call	_output	; output it
_waitFlag	btfss	secFlag,0	; wait on seconds change flag
	goto	_waitFlag	; skip until set
		
	clrf	secFlag	; clear seconds change flag
	movfw	seconds	; test seconds countdown 
	bnz	_nextLight	; light next LED if not zero
	
	movfw	TMR1L	;use Timer1 as random value for start delay
	movwf	startDelay	;write it into the start delay var
	bcf	STATUS,C	;clear carry ready for the following shift
	rrf	startDelay,F	;shift divides value in start delay by 2
			;so we get a 7-0 second delay rather than 14-0
	
_waitStart	movfw	startDelay	;load start delay into W (test for 0)
	bnz	_waitStart	;wait until end of delay (W = 0)
	bcf	INTCON,GIE	;disable interrupts (clear global int enable)
	clrf	lights	;set output to 0 (turn off LEDs)
	call	_output	;send to output

	
	goto	_waitKey	;We're all done, go and wait for another 
			;start sequence key press
	

; The PIC can sink more current than it can source from its outputs.  In addition and
; most importantly, RA3 is an open drain output so it can't source current.  This means
; that to turn an LED on requires the output to be 'active' low and since I don't like 
; working 'upside-down' I've put this little output code here to invert whatever is in
; the 'lights' variable and write it to the output port.
; 	
_output	movfw	lights	;load output var' into W
	xorlw	0x1F	;only change bits 4-0, leave 7-5
	movwf	PORTA	;write to Port A
	return		;and return
	
	end
	




