;===============================================================================
; Interrupt service handler
; F1 style race starting lights
;  
;
_intservice	movwf	save_W	; Preserve W, STATUS and PCLATH
	swapf	STATUS,w
	movwf	save_Status
	movfw	PCLATH
	movwf	save_PCLATH
	bank0
	
	;Test and branch to correct interrupt
	btfsc	INTCON,INTF	;test for RB0 edge interupt (jump start)
	goto	_JumpStart	;If set always do this, even if TOIF set
		
			;If it wasn't an edge interrupt then assume it
			;must have been the timer since no other Ints are
			;enabled.
				
	movlw	timerConst	;load W with timer constant
	movwf	TMR0	;write to Timer 0
	bcf	INTCON,T0IF	;and clear TimerO int flag
	
	decf	startDelay,F
	decfsz	tick,F	;decrement ticks
	goto	_exitINT	;exit Interrupt handler if ticks not 0
	movlw	timerTicks	;reset tick
	movwf	tick	;counter
	decf	seconds,F	;decrement seconds counter
	bsf	secFlag,0	;set bit 0 of seconds Flag variable
	
_exitINT	movfw	save_PCLATH	;Restore PCLATH
	movwf	PCLATH
	swapf	save_Status,W	;Restore STATUS and W
	movwf	STATUS	
	swapf	save_W,F
	swapf	save_W,W
	retfie		;exit from interupt handler


_JumpStart	bcf	INTCON,INTF	;clear RBO edge int flag
	
	; Implement the jump start code here.

	goto	_exitINT
	





;===============================================================================
