
; -----------------------------------------------------------------
; Set Time
; s dd hh:mm

_setTime	incf	FSR,F	;increment buffer pointer
	movfw	INDF	;get character from buffer
	xorlw	' '	;test for space
	bnz	_badCLI	;exit if no space
	;day
	incf	FSR,F
	movfw	INDF
	call	_a2h

	movwf	day
	
	incf	FSR,F	;increment buffer pointer
	movfw	INDF	;get character from buffer
	xorlw	' '	;test for space
	bnz	_badCLI	;exit if no space
	;hour
	call	_cv2
	btfsc	returnStatus,0;test status after conversion
	goto	_badCLI	;exit if bad
	movwf	hours
	addlw	-0x24	;test if hours >23
	skpnc	
	goto	_badCLI
	
	incf	FSR,F	;increment buffer pointer
	movfw	INDF	;get character from buffer
	xorlw	':'	;test for space
	bnz	_badCLI	;exit if no space
	;minutes
	call	_cv2
	btfsc	returnStatus,0;test status after conversion
	goto	_badCLI	;exit if bad
	movwf	minutes
	addlw	-0x60	;test if minutes >59
	skpnc	
	goto	_badCLI
	
	
_TandDtoRTC	clrf	i2c_address	;Set i2c memory address to 00
	clrw		
	call	_i2cWrite	;set Seconds to 00
	incf	i2c_address,F	;mem ++1
	movfw	minutes	;put minutes in W
	call	_i2cWrite	;set minutes
	incf	i2c_address,F	;mem ++1
	movfw	hours	;put hours in W
	call	_i2cWrite	;set hours
	incf	i2c_address,F	;mem ++1
	movfw	day	;put day in W
	call	_i2cWrite	;set day
	
	return


; -----------------------------------------------------------------
; Read two characters from input buffer and do ASCII hex to binary conversion
;	
_cv2	incf	FSR,F	;increment buffer pointer
	movfw	INDF	;get character from buffer
	movwf	asciiHi	;save
	incf	FSR,F	;increment buffer pointer
	movfw	INDF	;get character from buffer
	movwf	asciiLo	;save
	call	_a2byte	;do conversion
	movfw	a2byte	;get byte
	return

; -----------------------------------------------------------------
; Set Program
; pP [cC][hH] [awe] hh:mm

_setProg	incf	FSR,F	;increment buffer pointer
	movfw	INDF	;get character from buffer
	bz	_showProg
	call	_a2h
	btfsc	returnStatus,0
	goto	_badCLI
	addlw	.6	;test if >9 (W+6 gives DC=1 if W>9)
	skpndc		;skip if no digit carry
	goto	_badCLI	;else was >9 
	addlw	-.6	;restore value in W before test
	
	clrc		;quick multiply by 3
	movwf	i2c_address
	rlf	binary,W
	addwf	i2c_address,W
	addlw	0x08	;add offset of 8
	movwf	i2c_address
	
	incf	FSR,F	;increment buffer pointer
	movfw	INDF	;get character from buffer
	xorlw	' '	;test for space
	bz	_progDay

	movfw	INDF	;get character from buffer
	xorlw	'x'	;test for x
	skpz	
	goto	_badCLI
	clrf	minutes
	clrf	hours
	clrf	day
	goto	_progToNVRAM
	

_progDay	clrf	day	;clear variable as tests only set flag bits
_progCHDLoop	incf	FSR,F	;increment buffer pointer
	movfw	INDF	;get character from buffer
	skpnz		;test for 0 = end-of-buffer
	goto	_badCLI	;get out if end-of-buffer
	xorlw	' '	;test for space delimiter
	skpnz
	goto	_progCheck 	;loop complete, exit
			
	call	_progCHD	;call CHD settings
	goto	_progCHDLoop	;repeat loop



_progCheck	movlw	0xF0	;test output/flags
	andwf	day,W	;at least one must be set
	skpnz		;or program entry is invalid
	goto	_badCLI
	movlw	0x0F	;test days flag
	andwf	day,W	;at least one must be set
	skpnz		;or program entry is invalid
	goto	_badCLI
	

	;hour
_progTime
	call	_cv2
	movwf	hours
	btfsc	returnStatus,0;test status after conversion
	goto	_badCLI	;exit if bad
	addlw	-0x24	;test if hours >23
	skpnc	
	goto	_badCLI
	
	incf	FSR,F	;increment buffer pointer
	movfw	INDF	;get character from buffer
	xorlw	':'	;test for colon
	bnz	_badCLI	;exit if no colon

	;minutes
	call	_cv2
	movwf	 minutes
	btfsc	returnStatus,0;test status after conversion
	goto	_badCLI	;exit if bad
	addlw	-0x60	;test if minutes >59
	skpnc	
	goto	_badCLI
	
	call	_writeNewLine
	call	_showProgLine

_progToNVRAM	movfw	minutes
	call	_i2cWrite
	incf	i2c_address,F

	movfw	hours
	call	_i2cWrite
	incf	i2c_address,F

	movfw	day
	call	_i2cWrite

	return
;--------------------------------------------------------------------------
_progCHD
CHflag	EQU	4
HWflag	EQU	5

	movfw	INDF	;get character from buffer
	xorlw	R1off	;test for Relay1 Off command character
	skpnz		;skip next if not'c'
	bsf	day,CHflag	;set CH flag

	movfw	INDF	;get character from buffer
	xorlw	R1on	;test for Relay1 On command character
	bnz	_progHW	;branch if not 'C'
	bsf	day,CH	;set CH output bit
	bsf	day,CHflag	;set CH flag

_progHW	movfw	INDF	;get character from buffer
	xorlw	R2off	;test for Relay2 Off command character
	skpnz		;skip next if not'c'
	bsf	day,HWflag	;set CH flag

	movfw	INDF	;get character from buffer
	xorlw	R2on	;test for Relay2 on command character
	bnz	_progDays	;branch if not 'C'
	bsf	day,HW	;set CH output bit
	bsf	day,HWflag	;set CH flag
	
	
_progDays	movlw	'a'	;
	xorwf	INDF,W	;test for a
	skpnz		;skip next if not 'a'
	bsf	day,2	;set 'all' days flag
	movlw	'e'	;
	xorwf	INDF,W	;test for e
	skpnz		;skip next if not 'e'
	bsf	day,1	;set 'weekend' days flag
	movlw	'w'	
	xorwf	INDF,W	;test for w
	skpnz		;skip next if not 'w'
	bsf	day,0	;set 'weekday' days flag

	return		;return 


;**************************************************************************
_showProg	clrf	tc_counter1
	movlw	0x07
	movwf	i2c_address
	movlw	low _textNewline
	call	_writeText

_showProgLp	movlw	'p'
	call	_serialTX
	movfw	tc_counter1
	addlw	'0'
	call	_serialTX
	movlw	' '
	call	_serialTX

	movlw	0x04
	call	_i2cRead
	
	movfw	daycontrol
	bnz	_progset
	movlw	low _textUnused
	call	_writeText
	goto	_showNextProg
_progset	call	_showProgLine
	
	

_showNextProg	movlw	low _textNewline
	call	_writeText
	movlw	0x03
	addwf	i2c_address,F
	incf	tc_counter1,F
	movlw	.10
	xorwf	tc_counter1,W
	bnz	_showProgLp
	movlw	low _textNewline
	call	_writeText
	return
	
	
_showProgLine	movlw	'-'
	btfsc	daycontrol,HWflag		
	movlw	R2off 	;Relay2 Off command character
	btfsc	daycontrol,HW
	movlw	R2on	;Relay2 On command character
	call	_serialTX
	
	movlw	'-'
	btfsc	daycontrol,CHflag
	movlw	R1off	;Relay1 Off command character
	btfsc	daycontrol,CH
	movlw	R1on 	;Relay1 On command character
	call	_serialTX
	
	movlw	low _textPweek
	btfsc	daycontrol, 1
	movlw	low _textPend
	btfsc	daycontrol,2
	movlw	low _textPall
	
	call	_writeText
	
	movfw	hours
	call	_writeAscii
	movlw	':'
	call	_serialTX

	movfw	minutes
	call	_writeAscii
	return
		
	

