;-----------------------------------------------------------------
; LCD display driver software
; for HD44780 type display interface in 4 bit mode


; LCD data and control lines must be on the same port
; use bits 0-3 for LCD data lines.
; don't use any other port lines as outputs since
; they will be forced low by this code.
;
; memory variables used
;	lcdbyte	;temporary store for LCD data
;	lcdBCD	;temporary store for BCD data
;
LCD	EQU	PORTA
LCD_E	EQU	7
LCD_RS	EQU	6
waitTime	EQU	.10	;pause 4 x waitTime uS
		;time to wait after transfer to ensure LCD has
		;completed command / data before sending more

_lcdCmd	movwf	lcdbyte	;save data in temp var
	swapf	lcdbyte,W	;swap high and low nibbles
	andlw	0x0F 	;mask off high nibble
	movwf	LCD	;write to output port
	call	_lcdClock	;clock in high nibble

	movfw	lcdbyte	;get lcdbyte from temp var
	andlw	0x0F	;mask off high nibble
	movwf	LCD	;write to output port
	call	_lcdClock	;clock in low nibble
	goto	_lcdWait


_lcdBCD	movwf	lcdBCD	;save BCD byte
	swapf	lcdBCD,W	;swap nibbles and leave in W
	call	_lcdDec	;display high BCD number
	movfw	lcdBCD	;BCD into W and display low nibble
_lcdDec	andlw	0x0F	;mask high nibble
	iorlw	'0'	;quick convert of BCD to ASCII
_lcdChar	movwf	lcdbyte	;save data in temp var
	swapf	lcdbyte,W	;swap high and low nibbles
	andlw	0x0F 	;mask high nibble
	iorlw	(1<<LCD_RS)	;set RS bit high
	movwf	LCD	;write to output port
	call	_lcdClock	;clock in high nibble

	movfw	lcdbyte	;get lcdbyte in W
	andlw	0x0F	;mask high nibble
	iorlw	(1<<LCD_RS)	;set RS bit high
	movwf	LCD	;write to output port
	call	_lcdClock	;clock in low nibble
_lcdWait	movlw	waitTime	;setup pause to ensure command has completed
_lcdWaitL	addlw	0xFF	;add -1 (decrement W)
	bnz	_lcdWaitL	;loop until W=0	
	return
	
	
	
_lcdClock	bsf	LCD,LCD_E	;set the E control line
	nop
	bcf	LCD,LCD_E	;clear the E control line
	return		;back to calling fucntion
	

; Direct calls for common command functions
_lcdLine1	movlw	0x80	;move to 1st row, first column
	goto	_lcdCmd
_lcdLine2	movlw	0xC0	;move to 2nd row, first column
	goto	_lcdCmd
_lcdLine1W	addlw	0x80	;move to 1st row, column W
	goto	_lcdCmd
_lcdLine2W	addlw	0xC0	;move to 2nd row, column W
	goto	_lcdCmd
_lcdCurOn	movlw	0x0d	;Cursor on
	goto	_lcdCmd
_lcdCurOff	movlw	0x0c	;Cursor off
	goto	_lcdCmd
_lcdColon	movlw	':'	;display Colon
	goto	_lcdChar
_lcdSpace	movlw	' '	;display space
	goto	_lcdChar
_lcdMarker	movlw	'^'	;display a Marker
	goto	_lcdChar	
	
	
_lcdClr	movlw	0x01	;Clear display command
	call	_lcdCmd	;send command to LCD
	movlw	.2	;wait 2mS after issuing command to ensure
	goto	_delay	;it completes before sending further data
	



_lcdInit	movlw	0x20	;Set 4 bit mode
	call	_lcdCmd
;	movlw	0x28	;Set 4 bit mode, 2 lines,5x7
	movlw	0x2A	;Set 4 bit mode, 2 lines,5x10
	call	_lcdCmd
	movlw	0x06	;Set mode: Cursor+, Scroll off
	call	_lcdCmd
	movlw	0x0c	;Set display on, cursor off, blink off
	call	_lcdCmd
	goto	_lcdClr	;clear display

_lcdClrLine1    call	_lcdLine1
	call	_lcdClrLine
	goto	_lcdLine1
_lcdClrLine2	call	_lcdLine2
	call	_lcdClrLine
	goto	_lcdLine2

_lcdClrLine	movlw	.16
	movwf	tc_counter1
_lcdClearLoop	call	_lcdSpace
	decfsz	tc_counter1,F
	goto	_lcdClearLoop
	return
	
