;******************************************************************
; Find active key and perform action
;
; Key Switch 5 (bit 4) is a function shift key
; The shifted state is cleared either by pressing the key
; a second time or by the code for the shifted key fucntion.
;
; There are five keys scanned but currently only two are in use
; plus the shift function key
;
; The switches use the code in the serial interface routines to 
; set/clear outputs and manual mode flags, to save bytes/duplication
;
_keyAction

	btfsc	switchLast,0	;test sw0
	goto	_flipHW	;goto toggle HW relay setting, return from there
	btfsc	switchLast,1	;test sw1
	goto	_flipCH	;goto toggle CH relay setting, return from there
	

	

	btfsc	switchLast,2	;test sw0 - HotWater
	goto	_flipManHW	;goto invert HW manual bit, return from there
	btfsc	switchLast,3	;test sw1 - CentralHeating
	goto	_flipManCH	;goto invert CH manual bit, return from there
	
	btfss	switchLast,4	;test for key 5 active
	return		;return if key pressed not defined
			
			;sw4 pressed - Setup
	call	_FpSet	;Call front panel setup functions
	call	_lcdClr	;On return clear LCD
	return		;and return to main loop


_flipCH	movlw	(1<<CH)		;load W with CH bit
	xorwf	RelayOut,F		;invert bit in memory
	return

_flipHW	movlw	(1<<HW)		;load W with CH bit
	xorwf	RelayOut,F		;invert bit in memory
	return
	
_flipManCH	movlw	(1<<CH)		;load W with CH bit
	xorwf	manual,F		;invert bit in memory
	return

_flipManHW	movlw	(1<<HW)		;load W with CH bit
	xorwf	manual,F		;invert bit in memory
	return
