;**********************************************************
; Front Panel Time and Program setting routines
; 
;
;**********************************************************
	#define	IncKey	switchNow,3	
	#define	DecKey	switchNow,1
	#define	ProgKey	switchNow,1	
	#define	TimeKey	switchNow,3	
	#define	SetKey	switchNow,4
	#define	NextKey	switchNow,0
	#define	ClrKey	switchNow,2	
	#define	NoKey	switchNow,1	
	#define	YesKey	switchNow,3
	#define	EditKey	switchNow,0

; Write set question text to LCD
_FpSet	call	_lcdClr
	movlw	.2
	call	_lcdLine1W
	movlw	low _textFpSet
	call	_writeLCD
	movlw	.13
	call	_lcdLine1W
	movlw	low _textFpYes
	call	_writeLCD
	movlw	.14
	call	_lcdLine2W
	movlw	low _textFpNo
	call	_writeLCD
	clrf	fpProgCounter	
	
_SetSure	decf	fpProgCounter,F
	skpnz
	return
	movlw	.25	;load W with 25
	call	_delay	;call 25mS debounce delay
	call	_switchScan	;scan keys	
	btfsc	NoKey	;Test Program key
	return
	btfss	YesKey	;Test Time key
	goto	_SetSure	;not Time key either so loop
	
		
; Wait on user choice
_SetWhat	movlw	.12
	call	_lcdLine1W
	movlw	low _textFpTime
	call	_writeLCD
	movlw	.9
	call	_lcdLine2W
	movlw	low _textFpProg
	call	_writeLCD

_SetWhatLoop	call	_getFpKey
	btfsc	ProgKey	;Test Program key
	goto	_setFpProg	;Set Program
	btfss	TimeKey	;Test Time key
	goto	_SetWhatLoop	;not Time key either so loop
	;get here if Time set key pressed
;------------------------------------------------------------	
; set time and day		
_setFpTandD	call	_lcdClr
	call	_putFpSigns	; Write + & - signs to LCD
	call	_putFpNext
	movlw	RTC	; Read time and day from lCD
	movwf	i2c_device
	movlw	0x00
	movwf	i2c_address
	movlw	0x04	;read 3 bytes
	call	_i2cRead
	clrf	seconds	;set seconds to 0

_setFpDay
	movlw	.6
	call	_setMarker2
	
	movlw	.6	;set position day on LCD
	call	_lcdLine1W
	call	_Day2LCD	;write day to LCD
	movlw	.9
	call	_Time2LCD
	call	_getFpKey	;get key

	btfsc	NextKey
	goto	_setFpTimeIn
	btfsc	IncKey
	incf	day,f
	btfsc	DecKey
	decf	day,f
	call	_testFpDay
	goto	_setFpDay

_setFpTimeIn	call	_setFpTime
	call	_TandDtoRTC	;write new T&D to RTC
	return

_setFpTime	movlw	.6
	call	_clrMarker2
	movlw	.9
	call	_setMarker2
	movlw	hours
	movwf	FSR
	movlw	0x100-0x24
	movwf	fpTimeComp
	call	_adjustTime
	
	movlw	.9
	call	_clrMarker2
	movlw	.12
	call	_setMarker2
	decf	FSR,F	;point to minutes
	movlw	0x100-0x60
	movwf	fpTimeComp
	call	_adjustTime
	return
	
;------------------------------------------------------------		
; Function - text day between 1 and 7 and roll over
;	
_testFpDay	movfw	day	; put day in to W reg
	skpnz		; skip next if not 0
	movlw	0x07	; else set W=7
	btfsc	day,3	; Is day = 8 '1000' 
	movlw	0x01	; If yes set W=1
	movwf	day	; day=W
	return

;------------------------------------------------------------------------
; Function - Scan key switches and only return when a key is pressed
;
_getFpKey	movlw	.15	;load W with 15
	call	_delay	;call 15mS debounce delay
	call	_switchScan	;scan keys	
	bz	_getFpKey	;loop of no key pressed
	return		;else return with key

;------------------------------------------------------------------------
; Function - Write + and - to the LCD 	
;
_putFpSigns	movlw	.15
	call	_lcdLine1W
	movlw	'+'
	call	_lcdChar
	movlw	.15
	call	_lcdLine2W
	movlw	'-'
	call	_lcdChar
	return

;------------------------------------------------------------------------
; Function - Write  Next to the LCD 	
;
_putFpNext	call	_lcdLine2
	movlw	low _textFpNext
	call	_writeLCD
	return

;------------------------------------------------------------------------
; Function - Write Clear to the LCD 	
;
_putFpClear	call	_lcdLine1
	movlw	low _textFpClear
	call	_writeLCD
	return
;------------------------------------------------------------------------
; Function - Write Prg to the LCD 	
;
_putFpPrg	call	_lcdLine2
	movlw	low _textLCDprg
	call	_writeLCD
	return

;------------------------------------------------------------------------
; Adjust time
;
_adjustTime
	movlw	.9	;set char' position of time on LCD
	call	_lcdLine1W	

	call	_Time2LCD	;write time setting to LCD
	call	_getFpKey	;wait for key press
	
	btfsc	NextKey
	return
	
	btfsc	DecKey
	goto	_DecFpTime
	btfss	IncKey
	goto	_adjustTime
	
_IncFpTime	movfw	INDF	;W=INDF
	addlw	.7	;W=W+7
	skpdc		;skip next if Digit Carried
	addlw	-.6	;else subtract 6 to gives us W+1
	movwf	INDF	;save W to INDF
		
	movfw	fpTimeComp	;get roll over value 
	addwf	INDF,W	;subtract from time
	skpnc		;skip next if not 0
	clrf	INDF	;else clear INDF
	goto	_adjustTime


_DecFpTime

	movlw	.1	;set W=1
	subwf	INDF,w	;W=INDF-W
	skpdc		;skip if DC set
	andlw	0xF9	;x0 -> xF so mask to x9
	movwf	INDF	;save W back to INDF
	skpnc		;skip if C set (0x00 -> 0xFF)
	goto	_adjustTime
	
	movlw	0x59	;preset to max. val. for Hrs or Mins
	movwf	INDF
	movlw	0xA0
	xorwf	fpTimeComp,W
	skpnz
	goto	_adjustTime
	movlw	0x23
	movwf	INDF
	goto	_adjustTime

	
	decf	INDF,W
	addlw	.6
	skpdc
	addlw	-.7
	skpnc
	comf	fpTimeComp,W
	movwf	INDF
	goto	_adjustTime


;-------------------------------------------------------
; Set and clear single and double markers
;
_clrMarker2	call	_lcdLine2W
	call	_lcdSpace
	goto	_lcdSpace

_setMarker2	call	_lcdLine2W
	call	_lcdMarker
	goto	_lcdMarker

	
_clrMarker1	call	_lcdLine2W
	goto	_lcdSpace

_setMarker1	call	_lcdLine2W
	goto	_lcdMarker


