




;------------------------------------------------------------------------
; Front Panel Program setup
_setFpProg	clrf	fpProgNo	;clear program entry var'
	call	_lcdClr	;clear LCD
	call	_putFpSigns	;display + & - signs
	
	

_FpProgLoop	call	_putFpClear	;display 'Clr' text
	call	_putFpPrg	;display 'Prg' text
	movlw	.7
	call	_lcdLine2W
	movlw	'P'
	call	_lcdChar
	movlw	.8
	call	_lcdLine2W
	movfw	fpProgNo
	call	_lcdDec
	movfw	fpProgNo	;W= program entry var
	call	_FpGetPrg	;Get current Program from NVRAM
	call	_FpDisPrg	;display it on LCD

	call	_getFpKey	;Go and wait for key press
	btfsc	SetKey	;test for SetKey
	return		;exit

	btfsc	IncKey	;test for IncKey
	call	_FpNextPrg	;show next prog entry
	
	btfsc	DecKey	;test for DecKey
	call	_FpPrevPrg	;show prev progr entry
	
	btfsc	EditKey	;test for EditKey
	goto	_FpEditProg	;call edit function
	
	btfsc	ClrKey	;Test for ClearKey
	call	_FpClearProg	;erase current prog and save
	
	goto	_FpProgLoop	;loop
	
	
_FpNextPrg	movlw	-.9	;W = -9
	addwf	fpProgNo,W	;add to current Prog No
	skpnz		;skip if !=0
	clrf	fpProgNo	;else roll fpProgNo back to 0
	skpz		;skip the following Inc if Z flag true
	incf	fpProgNo,F	;else increment Prog No
	return
	
_FpPrevPrg	movlw	.10	;preload W=10
	tstf	fpProgNo	;Test Prog No
	skpnz		;Skip if !=0
	movwf	fpProgNo	;else roll fpProgNo back to 10	
	decf	fpProgNo,F	;else decrement Prog No
	return
	

;--------------------------------------------------------------
; read program number n
; enter with W = n
_FpGetPrg	call	_i2cMultiply	
	decf	i2c_address,F
	movlw	0x04	;read 4 bytes
	call	_i2cRead
	clrf	seconds
	return

_FpWritePrg	call	_i2cMultiply
	call	_progToNVRAM
	return

_i2cMultiply	clrc		;quick multiply by 3
	movfw	fpProgNo
	movwf	i2c_address
	rlf	fpProgNo,W	
	addwf	i2c_address,W
	addlw	0x08	;add NVRAM memory offset of 7
	movwf	i2c_address	;save in i2c address var
	return

;--------------------------------------------------------------
; display program on LCD

_FpDisPrg	movfw	day
	bnz	_DisPrg
	call	_setWipe	;Clear program from display
	movlw	.4
	call	_lcdLine1W
	movlw	low _textUnused
	call	_writeLCD
	return

_DisPrg	movlw	.4
	call	_lcdLine1W
	movlw	'-'
	btfsc	daycontrol,HWflag
	movlw	R2off	;Relay2 Off command character
	btfsc	daycontrol,HW
	movlw	R2on 	;Relay2 On command character
	call	_lcdChar

	movlw	'-'
	btfsc	daycontrol,CHflag		
	movlw	R1off 	;Relay1 Off command character
	btfsc	daycontrol,CH
	movlw	R1on	;Relay1 On command character
	call	_lcdChar
	call	_lcdSpace
	movlw	'w'
	btfsc	daycontrol, 1
	movlw	'e'
	btfsc	daycontrol,2
	movlw	'a'
	call	_lcdChar
	call	_lcdSpace	

	goto	_Time2LCD




;---------------------------------------------------------------------------
; Program entry clear
_FpClearProg	clrf	minutes
	clrf	hours
	clrf	day
			;write data back to RTC
	goto	_FpWritePrg	;function in settingsV2.inc)
	
;---------------------------------------------------------------------------
; Program entry edit	
_FpEditProg	call	_putFpNext	;put Nxt text on LCD
	bsf	daycontrol,HWflag
	movlw	.7
	call	_clrMarker2	
	call	_lcdLine1
	call	_lcdSpace
	call	_lcdSpace
	call	_lcdSpace
	movlw	.4
	call	_setMarker2
	clrf	fpProgCounter


	movlw	0x08
	movwf	fpEditLimit
	
	
_FpEditOut	call	_FpDisPrg
	call	_getFpKey
	btfsc	NextKey
	goto	_FpEditNxt1

	btfsc	IncKey
	call	_FpCountUp
	btfsc	DecKey
	call	_FpCountDown
	call	_dayControl
	movlw	0x0F
	andwf	daycontrol,F
	call	_dayControl
	iorwf	daycontrol,F
	goto	_FpEditOut

_FpEditNxt1	movlw	.4
	call	_clrMarker2
	movlw	.7
	call	_setMarker1
	clrf	fpProgCounter
	movlw	0x03
	movwf	fpEditLimit
	
_FpEditDay	call	_FpDisPrg
	call	_getFpKey
	btfsc	NextKey
	goto	_FpEditTime
	
	btfsc	IncKey
	call	_FpCountUp
	btfsc	DecKey
	call	_FpCountDown
	movlw	0xF0
	andwf	daycontrol,F
	call	_dayDay
	iorwf	daycontrol,F
	goto	_FpEditDay
	
_FpEditTime	call	_setFpTime
	movlw	.12
	call	_clrMarker2
	call	_FpWritePrg
	goto	_FpProgLoop
	

	
_FpCountUp	incf	fpProgCounter,F 
	movfw	fpEditLimit
	xorwf	fpProgCounter,W
	skpnz	
	clrf	fpProgCounter
	return
	
_FpCountDown	tstf	fpProgCounter	  ;Test Prog No
	bnz	_FpCDskip	  
	movfw	fpEditLimit
	movwf	fpProgCounter	
_FpCDskip	decf	fpProgCounter,F ;else decrement Prog No
	return

		
	if high  _DTStart != high _DTEnd
	  messg " ATTENTION: Table in '_dayTable' is crossing a page boundary "
	endif

_dayDay	movlw	high _DTStart
	movwf	PCLATH
	movfw	fpProgCounter
	addwf	PCL,F
_DTStart	retlw	.1
	retlw	.2
_DTEnd	retlw	.4
	
	if high  _DCStart != high _DCEnd
	  messg " ATTENTION: Table in '_dayControl' is crossing a page boundary "
	endif

_dayControl	movlw	high _DCStart
	movwf	PCLATH
	movfw	fpProgCounter
	addwf	PCL,F
_DCStart	retlw	b'00100000'	;-h
	retlw	b'10100000'	;-H
	retlw	b'00010000'	;c-
	retlw	b'01010000'	;C-
	retlw	b'00110000'	;ch
	retlw	b'10110000'	;cH
	retlw	b'01110000'	;Ch
_DCEnd	retlw	b'11110000'	;CH

;-------------------------------------------------------
; Clear LCD char pos 4-13
;	
_setWipe	movlw	.10
	movwf	tc_temp1
	movlw	.4
	call	_lcdLine1W
_setWipeLoop	call	_lcdSpace
	decf	tc_temp1,F
	bnz	_setWipeLoop
	return


	
