;*********************************************************************
; 
; DS1307 RTC 
;
;*********************************************************************


RTC	equ	0xD0
#define	heat	RelayOut,6
#define	water	RelayOut,7

;------------------------------------------
; Control
;
_timeControl 

	
	movlw	RTC	;DS1307 hardware address = 0xD0
	movwf	i2c_device	;initialise i2c device address
	movlw	0x00	;i2c memory address
	movwf	i2c_address	;set address to read from
	movlw	0x04	;read 4 bytes
	call	_i2cRead	;set number of bytes to read
			
			;move three of four bytes just read
	movfw	hours	;to working variables. Don't need seconds.
	movwf	rtc_hours	
	movfw	minutes
	movwf	rtc_minutes
	movfw	daycontrol
	movwf	rtc_day	
	
	movfw	rtc_minutesPrev ;
	xorwf	rtc_minutes,W	;test current minute with previous
	skpnz		;if not same go and test control entries
	return		;if same we're done

	movlw	0x07	
	movwf	i2c_address	;set control memory address
	movlw	0x0A	;set number of control entries to test
	movwf	tc_counter1

_tcLoop	movlw	0x04
	call	_i2cRead	;read control entry
	call	_CheckCtrl	;test and set outputs
	

	movlw	0x03	;W=3
	addwf	i2c_address,F	;add 3 to control memory address
	decf	tc_counter1,F	;decrement counter 
	bnz	_tcLoop	;loop if !0
	movfw	rtc_minutes	;get current minutes
	movwf	rtc_minutesPrev ;save in previous minutes
	
	
	return		;done
	


; daycontrol bit significance
; 76543210       
; ||   |||_Weekday
; ||   ||__Weekend
; ||   |___Everyday	
; ||_______Heat control
; |________Water control	
; 
	
			
_CheckCtrl	movfw	minutes	;get preset minute
	xorwf	rtc_minutes,W	;compare to time
	skpz		;skip next if match
	return		;else return
			
	movfw	hours	;get preset hour
	xorwf	rtc_hours,W	;compare to time
	skpz		;skip next if match
	return		;else return

	movf	daycontrol,F	;test preset day
	skpnz		;skip if not 0 
			;if daycontrol =0 then entry is not used
	return		;else return
	btfsc	daycontrol,2	;test bit 2 (all days)
	goto	_control	;
	btfsc	daycontrol,1	;test bit 1 (weekend)
	goto	_wkend	

_wkday	movfw	rtc_day	;test day for weekday
	addlw	.10	;add 10
	bndc	_control	;if rtc_day <6 then digit carry = 0
	return		;day doesn't match, we're done

_wkend	movfw	rtc_day	;test day for weekend
	addlw	.10	;add 10
	bdc	_control	;if rtc_day >5 then digit carry = 1
	return		;day doesn't match, we're done


_control	btfsc	manual,CH	;test for manual mode
	goto	_wctrl	;ignore program if manual enabled
	btfss	daycontrol,CHflag;test CHflag
	goto	_wctrl	;skip if CH flag not set
	btfsc	daycontrol,6	;test control
	bsf	heat	;set heating on
	btfss	daycontrol,6
	bcf	heat	;set heating off
	
_wctrl	btfsc	manual,HW	;test for manual mode
	return		;ignore program if manual enabled
	btfss	daycontrol,HWflag;test HWflag
	return		;return if HW flag not set
	btfsc	daycontrol,7
	bsf	water	;set water on
	btfss	daycontrol,7
	bcf	water	;set water off
	return

	
	
	
	
	
	
	

	
	
	
	
;
