;===============================================================================
;Computed goto's read text strings
;This code must be located within first 256 bytes of programme memory
;since PCLATH is set to zero		
;

	if high  _textMemEnd != 0
	  messg " ATTENTION: Table in '_getText' is crossing a page boundary "
	endif
	; /r = [CR] character. _writeText routine will automatically insert a [LF}
	; when it sends a [CR]
	; 0 is end-of-data delimiter			
_textMemSt
_textSpace	dt	"      ",0
_textLock	dt	"Locked",0
_textFpYes	dt	"Yes",0
_textFpNo	dt	"No",0
_textFpSet	dt	"Setup?",0
_textFpTime	dt	"Time",0
_textFpProg	dt	"Program",0
_textFpClear	dt	"Clr",0
_textFpNext	dt	"Nxt",0
_textPrompt	dt	"\r# ",0	
_textQuestion	dt	"\r? ",0
_textStartup	dt	"CH Programmer",0
_textNewline	dt	"\r",0
_textVersion	dt	"V2.0.2 28/05/05",0
_textErr	dt	"Er",0
_textMon	dt	"Mo",0
_textTue	dt	"Tu",0
_textWed	dt	"We",0
_textThu	dt	"Th",0
_textFri	dt	"Fr",0
_textSat	dt	"Sa",0
_textSun	dt	"Su",0
_textOnL	dt	"On ",0
_textOnR	dt	" On",0
_textOff	dt	"Off",0
_textHeat	dt	"\rC/Heating: ",0
_textWater	dt	"\rHot Water: ",0
_textI2Cfail	dt	"I2C Er",0
_textTime	dt	"\rTime ",0
_textMemI2C	dt	"\rMemory ",0
_textRAMinit	dt	"RTC init",0
_textValid	dt	"RTC Ok",0
_textPweek	dt	" Week ",0
_textPend	dt	" w/E  ",0
_textPall	dt	" All  ",0
_textUnused	dt	"free",0
_textTimed	dt	", Program",0
_textManual	dt	", Manual",0
_textLCDman	dt	"Man",0
_textLCDprg	dt	"Prg",0
_textLCDwdt	dt	"WDT ",0
_textVT100init	dt	0x1B,"c",0
_textMemEnd	dt	0


_getText	clrf	PCLATH	;clear PCLATH (table must be in Page Zero)
	movf	txtidx,w	;load W with index value
	movwf	PCL	;and put in PCL
			;jump into data table which contains
			;character string as RETLW instructions

;====================================================================================	
; Read a text string and transmit to terminal
; string MUST be terminated with 0x00
; Call with required string index Low byte base address in W (e.g movlw  low  _textBase)
; Code checks to see if a [CR] was sent and automatically inserts a [LF].
;
_writeText	movwf	txtidx	;put text string base address in index
_wtloop	call	_getText	;get character from string to transmit
	iorlw	0x00	;test for 0x00, end-of-string delimiter
	skpnz		;skip if not end
	 return		;else return
	call	_serialTX	;otherwise call data transmit routine
	xorlw	0x0D	;Test if we just sent a [CR] - set Z flag
	movlw	0x0A	;load W with [LF] character - Z flag not affected
	skpnz		;skip if Z flag clear
	call	_serialTX	;send [LF] to terminal
_writeInc	incf	txtidx,F	;increment index to point at next character
	goto	_wtloop	;go round again
	

;====================================================================================	
; Send new line to serial terminal
; Newlines are quite common so added this function to save a few bytes
_writeNewLine	movlw	low _textNewline;put newline text pointer in W
	goto	_writeText	;goto _writeText and return from there

	
;====================================================================================	
; Read a text string and transmit to terminal
; string MUST be terminated with 0x00
; Call with required string index Low byte base address in W (e.g movlw  low  _textBase)
; Code checks to see if a [CR] was sent and automatically inserts a [LF].
;
_writeLCD	movwf	txtidx	;put text string base address in index
_wLCDloop	call	_getText	;get character from string to transmit
	iorlw	0x00	;test for 0x00, end-of-string delimiter
	skpnz		;skip if not end
	 return		;else return
	call	_lcdChar	;otherwise call data transmit routine
_wLCDinc	incf	txtidx,F	;increment index to point at next character
	goto	_wLCDloop	;go round again
	
;===============================================================================
; Convert byte in W to two ASCII hex characters and send to Serial Port
_writeAscii	call	_h2a	;Convert to ASCII hex
	movfw	asciiHi	;load ASCII hex hi nibble in W
	call	_serialTX	;send to terminal
	movfw	asciiLo	;load ASCII hex lo nibble in W
	goto	_serialTX	;send to terminal, return from there	

	
;===============================================================================
; Convert byte in W to two ASCII hex characters and send to LCD
_lcdAscii	call	_h2a	;Convert to ASCII hex
	movfw	asciiHi	;load ASCII hex hi nibble in W
	call	_lcdChar	;send to terminal
	movfw	asciiLo	;load ASCII hex lo nibble in W
	goto	_lcdChar	;send to terminal, return from there	
		

	
