; =====================================================================
; switchscan.inc
;
; Scan switches and return key down edge detects in W and in switchLast.
;
; Current active keys are returned in switchNow
; IMPORTANT... DO NOT change values in switchNow outside this code
;
; bit = 1 only if key down edge detected
; bit = 0 if key up/down or released edge detected
; Scans five key switches on PortA I/O lines 6,3,2,1,0
; Set bits 4,3,2,1,0 in switchLast var
; 
; KeyIn I/O line should be pulled high with a 10K resistor
; switches should be commoned to KeyIn line and connected individualy
; to scan lines via 1N4148 or similiar diode (cathode to scan line)
;
; for reference; Physical key presses are active low,
; switch data returned in variables is active high
;
; In this application I/O lines are shared with the LCD display
; so we have to ensure the LCD 'E' control line is held low
;
ksPort	EQU	PORTA	;port keys connected to
KeyIn	EQU	4	;key detect port input bit


_switchScan	movlw	high _keyLookup	;ensure PCLATH is
	movwf	PCLATH	;setup for lookup table
	movfw	switchNow	;put switch now in W
	movwf	switchLast	;save to switch Last
	clrf	switchNow	;clear switchNow
	clrf	tc_counter1	;clear pointer	
_keyScanLoop	movfw	tc_counter1	;load pointer into W reg
	call	_keyLookup	;get scan line port data
	movwf	ksPort	;write key scan data to port
	
	addlw	0x00	;test W=0 and clear Carry in one instruction - neat	
	bz	_keyDone	;if data returned from lookup is zero, we're done 
	rlf	switchNow,F	;else shift switchNow one bit left
			;[above provides 3uS gap between I/O write and read]
	
	btfss	ksPort,KeyIn	;test KeyIn port bit and skip next if 1 (key up)
	bsf	switchNow,0	;else set bit 0 of switchNow var (key down)
	incf	tc_counter1,F	;increment lookup pointer
	goto	_keyScanLoop	;loop
	
_keyDone	movfw	switchNow	;load switchNow var into W reg
	xorwf	switchLast,F	;Detect edge and save current switches
	andwf	switchLast,F	;mask any detected key release edges (hi to lo)
		
	goto	_clearWDT	;return with detected key down edges in W
		
_keyLookup			;key scan port data
	addwf	PCL,F	;using looktable here because keys
	retlw	b'00111111'	;aren't on contiguos port lines
	retlw	b'01110111'	;and bit 7 drives LCD Enable control which
	retlw	b'01111011'	;must be held low to avoid spurious access
	retlw	b'01111101'	;
	retlw	b'01111110'	;Key scan line is active low
	retlw	.0	;all scan lines don't need to be low at the
_keyLookupEnd			;same time so use zero as end of scan indicator

	
	if high _keyLookup != high _keyLookupEnd
	  messg " ATTENTION: table '_keyLookup' is crossing a page boundary "
	endif		
