;**********************************************************
; Ascii / Hex conversions
; functions
; _h2a	Converts byte to two character ASCII hex
; _a2h	Converts single ASCII character to binary value
; _a2byte	Converts two ASCII characters to binary byte
;
; Memory Variables:
;  binary
;  asciiLo
;  asciiHi
;  a2byte
;  returnStatus
;
;**********************************************************
; Byte to ASCII Hex conversion 
;
; e.g. W = 1010 0110 returns asciiHi = 'A' asciiLo = '6'
;
; Enter with Byte to convert in W
; Result returned in asciiHi, asciiLo.
; Destroys W, binary
; No returnStatus
;
_h2a	movwf	binary	;save W in binary
	call	_h2aNibble	;do conversion for Lo Nibble
	movfw	asciiHi	;result is in asciiHi,
	movwf	asciiLo	;move to asciiLo
	swapf	binary,F	;Get Hi nibble into Lo nibble for conversion
	goto	_h2aNibble	;goto conversion not call since....return in
			;subroutine gets back to original call (save a byte)
_h2aNibble	movlw	0x0F	;load bit mask
	andwf	binary,W	;mask out upper 4 bits in W

	addlw	 -.10           ;subtract 10
	skpnc	 	;skip if <10
	 addlw 	'A'-'0'-.10	;add ascii A - (ascii 0) - 10
	addlw 	'0'+.10  	;add ascii 0 + 10 (that we subtracted first)
	movwf	asciiHi	;save result in asciiHi
	return		;else result complete

;**********************************************************
;ASCII hex to binary conversion
; Call with ASCII character in W
; Result is stored in binary and also returned in W
; Status is returned in returnStatus:
;  if returnStatus != 0 then input data wasn't in the range 0-9, A-F; result invalid.
;  if returnStatus = 0 then result returned in var binary is valid
; Destroys W
;
_a2h	clrf	returnStatus	;set returnStatus to 0
	movwf	asciiLo	;put working data in W 
	sublw	'F'	;Test ASCII data
	 bnc	_badAscii	;Character > F
	movlw	'A'	;Test ASCII data
	subwf	asciiLo,W	;Character =<A
 	 bnc	_test09	;do test for input between 0-9
	addlw	.10	;else add 10 to W 
	movwf	binary	;save result in var binary
	return		;return to call
_test09	movfw	asciiLo	;put working data in W 
	sublw	'9'	;Test ASCII data
	 bnc	_badAscii	;Character > 9
	movlw	'0'	;Test ASCII data
	subwf	asciiLo,W	;Character =<0
	 bnc	_badAscii	;tested for A-F, 0-9, no match so input was bad
	movwf	binary	;else it was good, save result
	return		;and return to call
_badAscii	incf	returnStatus,F	;Make returnStatus !=0
	return		;and return error

;**********************************************************
;Two ASCII character to binary byte
;
; e.g.  asciiLo = 43 [C], asciiHi = 34 [4] returns a2byte = 1100 0100
;
; Enter with ASCII hex in AsciiLo, AsciiHi. Alpha characters in upper case only
; Result is stored in a2byte
; Status is returned in returnStatus
;  if returnStatus != 0 then input data wasn't in the range 0-9, A-F; result invalid.
;  if returnStatus = 0 then result returned in var a2byte is valid
; AsciiHi is unaffected
;
_a2byte	movfw	asciiLo	;put ascii lo into W
	call	_a2h	;call conversion
	movf	returnStatus,F	;test return status
	skpz		;skip next if 0
	 return		;else conversion bad, return to call
	swapf	binary,W	;get result
	movwf	a2byte	;save in a2byte
	movfw	asciiHi	;put asciiHi into W
	call	_a2h	;call conversion
	movf	returnStatus,F	;test return status
	skpz		;skip next if 0
	 return		;else conversion bad, return to call
	movfw	binary	;put result in W
	iorwf	a2byte,F	;combine two results
	swapf	a2byte,F	;swap the nibbles
	return
;**********************************************************
