;**********************************************************************
;                                                                     *
;    8 Channel PWM LED Chaser for PIC 16F628/A                        *
;                                                                     *
;    Filename:                  pro481v301.asm                        *
;    Date:                      21/02/2021                            *
;    File Version:              3.0.1                                 *
;                                                                     *
;    Author:                    Pete Griffiths                        *
;    Company:                   http://picprojects.org.uk             *
;                                                                     * 
;    Written and assembled under MPLAB Version 8.70                   *
;                                                                     *
;    Before assembling code set correct PIC processor in MPLAB        *
;    from menu option Configure - Select Device                       *
;                                                                     *
;    Use with 16F627/628 16F627A/628A only                            *
;                                                                     *
;    The devices with 1K program memory ( 16F627/627A                 *
;    will need some Sequences in pwmc_SeqData.inc file removing       *
;    to fit the code in their limited memory.                         *
;                                                                     *
;    27/07/2011                                                       *
;                                                                     *
;    PWM LED Chaser variant code for use with:                        *
;    PCB480C,					*
;                                                                     *
;    Version 3.x.x code allows sequence stepping from either          *
;    internal timing data, external R/C timing or external logic      *
;                                                                     *
;    21/02/2021                                                       *
;    - Fix issue with Watchdog timer reset before main code is        *
;      running when powering up in manual sequence select mode        *                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:                                                           *
;     1. PIC 16F628A datasheet can be downloaded from                 *
;        http://ww1.microchip.com/downloads/en/DeviceDoc/40044b.pdf   *
;                                                                     *
;     2. See also MPASM User Guide(UG) which can be downloaded from:  *
;        http://ww1.microchip.com/downloads/en/DeviceDoc/33014J.pdf   *
;        http://picprojects.org.uk/projects/ledchaser/                *
;                                                                     *
;     3. This code uses Pseudo-instructions listed in the MPASM User  *
;        guide, Part 4, Appendix A.5                                  *
;                                                                     *
;     4. For list of Radix types see MPASM UG Section 3.4, Table 3-3  *
;                                                                     *
;**********************************************************************



              ifdef __16F628A

               #include <p16f628A.inc>      ; Standard include file
                                            ; defines processor specific variable definitions
                                            ; See MPASM UG Section 4.41

              ;------------------------------------------------------------------------------------
              ; '__CONFIG' directive is used to embed configuration data within .asm file.
              ; The lables following the directive are located in the respective .inc file.
              ; See respective data sheet for additional information on configuration word.
              ; and also see MPASM UG Section 4.12

               __CONFIG   _CP_OFF & _WDT_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _LVP_OFF & _MCLRE_ON

              endif

              ifdef __16F628

               #include <p16f628.inc>
               __CONFIG   _CP_OFF & _WDT_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _LVP_OFF & _MCLRE_ON

              endif

              

              ;------------------------------------------------------------------------------------
              ; Suppress specific warning messages
              ; see MPASM UG Section 4.29 for errorlevel directive       
              ; see MPASM UG Section 8.4 for assembler message descriptions
              ;
              errorlevel -302     ; suppress banksel warning messages during assembly

              ;------------------------------------------------------------------------------------
              ; define variables in General Purpose Register (GPR) memory
              ; See MPASM UG Section 4.8
              ; note: 16F84A GPR start at 0x0C but most other mid-range PICs start at 0x20
              ; We use 0x20 here for compatibilty with newer PICs

              cblock 0x20
                firstGPR:0                ; mark start of GPR memory used
                state                     ; used by function state selector
                copyPORTB                 ; working variable, holds copy of PORTB
	  portaNow		; working variable, detects rising edge on extClkIn
	  portaLast
                vc0,vc1,vc2,vc3,vc4       ; vertical counter bits 
                hiReload                  ; vertical counter reload hi 
                loReload                  ; vertical counter reload lo
                pwm                       ; pwm counter
	  pwmOutput		; pwm port data working variable
                holdTime                  ; sequence line hold time
                repeatCount               ; repeat seqeunce count
                RandMask                  ; mask to AND random number with
                seqIdxLo                  ; Lo byte address index pointer to start of selected sequence  
                seqIdxHi                  ; Hi byte address index pointer to start of selected sequence
                seqTotal                  ; Total number of sequences in data
                seqMatch                  ; working variable
                seqCount                  ; working variable
                forward                   ; working regsiter for mirroring data
                reverse                   ; working regsiter for mirroring data
                reloadTemp                ; temporary holding variable for loReload
                tick                      ; timer0 ticks 
                swTimer                   ; switch hold down timer
                flags                     ; function flags register
	  mode		; mode flags register
                indexLo                   ; Lo byte sequence line data address pointer
                indexHi                   ; Hi byte sequence line data address pointer
                save_W                    ; save W during interupt
                save_Status               ; save STATUS during interupt
                save_PCLATH               ; save PCLATH
	  saveModeTimerL	; holdoff timer for saving opmode to EEPROM high
	  saveModeTimerH	; holdoff timer for saving opmode to EEPROM low
	  eesave_W		; temp register used in EEPROM routings
                LFSRH                     ; Random number shift regsiter high byte
                LFSRL:0                   ; Random number shift register low byte
                lastGPR                   ; mark last GPR register used 
                                          ; (required by GPR initialisation code)

              endc

;--------------------------------------------------------------------------------------------------------------------
; EEPROM data
; 	; program parameters
	org 0x2100
	de .0
	de .1
	de .0

	; embed firmware release info
	de " PRO481vs PWM LED Chaser "
	de " V3.0.1 - variable speed"
	de " 21/02/2021 "
	de " picprojects.org.uk "
;--------------------------------------------------------------------------------------------------------------------

; Define bank select pseudo instructions to make code more readable
#define   bank0     bcf       STATUS,RP0          ; Sel Bank 0
#define   bank1     bsf       STATUS,RP0          ; Sel Bank 1

;--------------------------------------------------------------------------------------------------------------------
;
; See MPASM UG Secdtion 4.27 for definition of equ directive

switch        equ 4         ; Port bit switch connected to

; External speed control
; RA7 input (timing clock input, chase sequence 'steps' on rising edge)
; RB3 input (int/ext clock select - input low uses external signal to 'step' chase sequence)
; RB0 software oscillator output
extClkIn	equ 7	; RA7
swOscOut	equ 0	; RB0
clkSel	equ 3	; RB3


; external timing input uses a resistor between RB3 and RB0 and timing capacitor between
; RB0 and GND.  Software drives RB3 high and low to charge and discharge the timining
; capacitor.  RB0 is a Schmitt trigger input that sets the INTF flag bit on a (rising) edge
; that is used to 'step' the chaser sequence.
; If the resistor/capacitor are not used, the RB0 input can be driven from an external
; oscillator, sound trigger etc. in the same manner.
;
; Chaser steps on rising edge of RB0.  This sets the INTF interrupt flag bit.
; It can be changed to step on a falling edge by clearing the INTEDG bit in 
; the OPTION register(change in pro481v3_start.inc)



cSAVETIME EQU	  d'4'	; holdoff timer constant for saving EEPROM data
cTIMER    EQU   d'157'
cTICKS    EQU   d'50'
; 4Mhz oscillator clock, gives TMR0 clock = 1Mhz.
; Write to timer0 inhibits clock for 2 clock cycles
; TMR0 prescaler of 1:2 gives
; 1Mhz / ((256-157+2) x 2) = 5Khz = 0.2mS
; 50 x 0.2mS = 10mS
; So the sequence hold time will be 10mS x holdTime, giving a range of
; 1 = 10mS thru 254 = 2.54S
; remember that a holdtime value of 255 indicates the end of the sequence so DON'T USE IT

; define flag bits
fHoldTimeout  EQU           0             ; flag set by ISR, cleared by Table Lookup function
fSwitch       EQU           1             ; flag 
fsetupRun     EQU           2             ; 0=run mode / 1=setup mode
fTick         EQU           3             ; timer tick flag
fSaveMode	EQU	4	; set indicates opmode needs writing to EEPROM, clear indicates no data to write
;	EQU	5	; not used
fMirrorData   EQU           6             ; flag set, Table read reverses bits in data word [** This flag must be Bit 6 **]
fMirrorNext   EQU           7             ; flag tells code current sequence should be mirrored next time

#define   canMirror 1<<fMirrorData        ; Don't change the position of this bit, sequence data expects it here

; define mode bits
modeSeq	EQU	0
modeRan	EQU	1
modeMan	EQU	2
modeSleep	EQU	3


;--------------------------------------------------------------------------------------------------------------------
; Program code starts here
;
; See MPASM UG Section 1.7.1, and Example 1-1
;
; Labels      Mnemonics     Operands                     Comments
;             Directives
;             Macros
;
RESET_VECTOR  org           0x000                       ; see MPASM UG Section 4.50 
              goto          START                       ; START label is in pwmc_start.inc

INTERRUPT_V   org           0x004                       ; Interrupt handler code must follow this origin statement
              #include pro481v3_inth.inc                ; include Interrupt Handler code block

              #include pro481v3_statef.inc              ; include main state function code block (must reside in page 0)
              #include pro481v3_start.inc               ; include reset and initialisation code
              #include pro481v3_functions.inc           ; include all program functions
              #include pro481v3_SeqMacro.inc            ; include MACRO definitions for sequence data 
                                                        ; used for creating sequence data tables

; ------------------------------------------------------------------------------------------------------

; DO NOT CHANGE OR REMOVE this label
SeqBaseAddr   ; label marks base address for start of sequence data.  

              ; Include your sequence data file(s) here
              
	#include pro481v3_SeqData.inc                 ; file containg sequence data 
	;#include pro481_xmastree.inc               ; alternate data for use with xmas tree pcb
              

              ; Do not remove this instruction
_markLast     retlw         .255          ; Ensure last sequence is marked
; ------------------------------------------------------------------------------------------------------

              end           ; end of instructions, always needed
