; PWM LED Chaser Interrupt Handler
; rev 3.0.0
              movwf         save_W        ; Preserve W, STATUS and PCLATH
              swapf         STATUS,w
              movwf         save_Status
              movfw         PCLATH
              movwf         save_PCLATH
	clrf	PCLATH
              bank0

	clrwdt		;clear watchdog timer
              movlw         cTIMER        ;load W with timer constant
              addwf         TMR0,F        ;write to Timer 0
              bcf           INTCON,T0IF   ;and clear TimerO int flag

              call          _pwm         		; drive LEDs (write to output ports)
	;-----------------------------------------------------------------
	; V3 - software oscillator / ext clock input


	; if extClkIn is low we need to charge the timing capacitor by setting
	; swOscOut bit high.
	; else if extClkIn is high we need to discharge the timing capacitor 
	; by setting the swOscOut bit low.
	
	bcf	copyPORTB, swOscOut	; setup for oscillator output low
	movfw	PORTA
	andlw	1<<extClkIn
	movwf	portaNow
	skpnz
	bsf	copyPORTB, swOscOut	; setup oscillator output high
	
	; detect rising edge, 
	xorwf	portaLast,W
	andwf	portaLast,F
	btfss	portaLast,extClkIn	; if bit set, rising edge detected
	goto	_noClkEdge
	
	btfsc	PORTB, clkSel	      ; If port bit high use external clock
              goto	_noClkEdge	      ; else continue with interrupt handler code
              decfsz          holdTime,F        ; decrement holdtime counter, skip if timed out
	goto	_noClkEdge	      ; else continue with interrupt handler code
              bsf           flags, fHoldTimeout ; set hold timeout flag bit
	
	; copy current port value to last ready for next pass
_noClkEdge    movfw	portaNow
	movwf	portaLast

	;-----------------------------------------------------------------
	decfsz        tick,F        ;decrement ticks
              goto          _exitINT      ;exit Interrupt handler if ticks not 0
              movlw         cTICKS        ;reload tick
              movwf         tick          ;counter
              
              bsf           flags, fTick        ; set tick timeout flag bit
              

	btfss	PORTB, clkSel	      ; If port bit high use internal clock
              goto	_saveCheck	      ; else continue with interrupt handler code
              decfsz          holdTime,F        ; decrement holdtime counter, skip if timed out
              goto	_saveCheck	      ; else continue with interrupt handler code
              bsf           flags, fHoldTimeout ; set hold timeout flag bit

_saveCheck	
	btfss	flags, fSaveMode
	goto	_exitINT
	decfsz	saveModeTimerL,F
	goto	_exitINT
	decfsz	saveModeTimerH,F
	goto	_exitINT
	call	save.opmode



_exitINT    	movfw         save_PCLATH   ;Restore PCLATH
              movwf         PCLATH
              swapf         save_Status,W ;Restore STATUS and W
              movwf         STATUS        
              swapf         save_W,F
              swapf         save_W,W
              retfie                      ;exit from interupt handler